/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import androidx.annotation.RestrictTo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ListUtil {
    public static <T> List<T> getSafeList(List<T> list) {
        if (ListUtil.isListEmpty(list)) {
            return new ArrayList();
        }
        return list;
    }

    public static boolean isMapEmpty(Map map) {
        return null == map || map.size() == 0;
    }

    public static boolean isListEmpty(List list) {
        return null == list || list.size() == 0;
    }

    public static boolean isArrayEmpty(Object[] arr) {
        return null == arr || arr.length == 0;
    }

    public static <T> List<T> deepCopy(List<T> src) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(src);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            List dest = (List)in.readObject();
            return dest;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }
}

