/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SoftInputUtil {
    public static void showSoftInput(Context context) {
        if (context == null) {
            return;
        }
        try {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            if (imm != null) {
                imm.toggleSoftInput(0, 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showSoftInput(Context context, View view) {
        if (context == null || view == null) {
            return;
        }
        try {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            if (imm != null) {
                imm.showSoftInput(view, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hideSoftInput(Context context, View view) {
        if (context == null || view == null) {
            return;
        }
        try {
            InputMethodManager immHide = (InputMethodManager)context.getSystemService("input_method");
            if (immHide != null) {
                immHide.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

