/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import java.util.HashMap;
import java.util.Map;
import net.aihelp.config.AIHelpContext;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SpUtil {
    private Context context = AIHelpContext.getInstance().getContext().getApplicationContext();
    private static volatile SpUtil INSTANCE;
    private static final String FILE_NAME = "aihelp_share_data";
    private static final String FILE_NAME_OF_SDK_VERSION_1 = "com_ab_shared_preferences";
    public static final String KEY_DEVICE_ID_OF_SDK_VERSION_1_x = "suuid";
    public static final String KEY_DEVICE_ID_OF_SDK_VERSION_2_x = "key_device_id";

    public void init(Context context) {
        this.context = context;
    }

    private SpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SpUtil> clazz = SpUtil.class;
        synchronized (SpUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SpUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void put(String key, Object object) {
        if (this.isBadContext()) {
            return;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = sp.edit();
        if (object instanceof String) {
            editor.putString(key, (String)object);
        } else if (object instanceof Integer) {
            editor.putInt(key, ((Integer)object).intValue());
        } else if (object instanceof Boolean) {
            editor.putBoolean(key, ((Boolean)object).booleanValue());
        } else if (object instanceof Float) {
            editor.putFloat(key, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            editor.putLong(key, ((Long)object).longValue());
        } else {
            editor.putString(key, object.toString());
        }
        editor.apply();
    }

    public long getLong(String key) {
        if (this.isBadContext()) {
            return 0L;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getLong(key, 0L);
    }

    public long getLong(String key, long defaultObject) {
        if (this.isBadContext()) {
            return 0L;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getLong(key, defaultObject);
    }

    public float getFloat(String key) {
        if (this.isBadContext()) {
            return 0.0f;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultObject) {
        if (this.isBadContext()) {
            return 0.0f;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getFloat(key, defaultObject);
    }

    public int getInt(String key) {
        if (this.isBadContext()) {
            return 0;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getInt(key, 0);
    }

    public int getInt(String key, int defaultObject) {
        if (this.isBadContext()) {
            return 0;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getInt(key, defaultObject);
    }

    public boolean getBoolean(String key) {
        if (this.isBadContext()) {
            return false;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultObject) {
        if (this.isBadContext()) {
            return false;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getBoolean(key, defaultObject);
    }

    public String getString(String key, String defaultObject) {
        if (this.isBadContext()) {
            return "";
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getString(key, defaultObject);
    }

    public String getString(String key) {
        if (this.isBadContext()) {
            return "";
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getString(key, "");
    }

    public void remove(String key) {
        if (this.isBadContext()) {
            return;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.remove(key).apply();
    }

    public void clear() {
        if (this.isBadContext()) {
            return;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear().apply();
    }

    public boolean contains(String key) {
        if (this.isBadContext()) {
            return false;
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.contains(key);
    }

    public Map<String, ?> getAll() {
        if (this.isBadContext()) {
            return new HashMap();
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME, 0);
        return sp.getAll();
    }

    public String get1_xDeviceId() {
        if (this.isBadContext()) {
            return "";
        }
        SharedPreferences sp = this.context.getSharedPreferences(FILE_NAME_OF_SDK_VERSION_1, 0);
        return sp.getString(KEY_DEVICE_ID_OF_SDK_VERSION_1_x, "");
    }

    public String get2_xDeviceId() {
        return this.getString(KEY_DEVICE_ID_OF_SDK_VERSION_2_x);
    }

    private boolean isBadContext() {
        if (this.context == null && AIHelpContext.getInstance().getContext() != null) {
            INSTANCE = new SpUtil();
            return true;
        }
        return false;
    }
}

