/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.RestrictTo;
import java.util.WeakHashMap;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.init.AIHelpSupport;
import net.aihelp.ui.widget.snackbar.Snackbar;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public enum ToastUtil {
    INSTANCE;

    private Toast toast;
    private Snackbar snackbar;
    private final WeakHashMap<View, Snackbar> viewToSnackBarMapping = new WeakHashMap();

    public void makeRawToast(Context context, String text) {
        this.makeRawToast(context, text, true);
    }

    public void makeRawToast(final Context context, final String text, boolean checkAIHelpShowing) {
        if (checkAIHelpShowing && !AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ToastUtil.this.toast != null) {
                        ToastUtil.this.toast.setView(null);
                        ToastUtil.this.toast.setText((CharSequence)text);
                    } else {
                        ToastUtil.this.toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)0);
                    }
                    ToastUtil.this.toast.show();
                }
                catch (Exception e) {
                    Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)0).show();
                }
            }
        });
    }

    public void makeText(final Context context, final String text, final boolean isLong) {
        if (!AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    View mView = LayoutInflater.from((Context)context).inflate(ResResolver.getLayoutId("aihelp_toast_center_view"), null);
                    TextView textView = (TextView)mView.findViewById(ResResolver.getViewId("aihelp_toast_txt"));
                    Styles.reRenderTextView(textView, text);
                    if (ToastUtil.this.toast != null) {
                        textView.setText((CharSequence)text);
                    } else {
                        ToastUtil.this.toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)(isLong ? 1 : 0));
                    }
                    ToastUtil.this.toast.setView(mView);
                    ToastUtil.this.toast.setGravity(17, 0, 0);
                    ToastUtil.this.toast.show();
                }
                catch (Exception e) {
                    Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)0).show();
                }
            }
        });
    }

    public void makeTextWithIcon(final Context context, final String text, final boolean isLong) {
        if (!AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    View mView = LayoutInflater.from((Context)context).inflate(ResResolver.getLayoutId("aihelp_toast_network_fine"), null);
                    TextView textView = (TextView)mView.findViewById(ResResolver.getViewId("aihelp_toast_txt"));
                    textView.setText((CharSequence)text);
                    if (ToastUtil.this.toast != null) {
                        textView.setText((CharSequence)text);
                    } else {
                        ToastUtil.this.toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)(isLong ? 1 : 0));
                    }
                    ToastUtil.this.toast.setView(mView);
                    ToastUtil.this.toast.setGravity(17, 0, 0);
                    ToastUtil.this.toast.show();
                }
                catch (Exception e) {
                    Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)0).show();
                }
            }
        });
    }

    public void showSnackBar(final View view, final String message, final boolean isLong) {
        if (!AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (message != null && message.length() != 0) {
                        if (view != null) {
                            ToastUtil.this.snackbar = Snackbar.make(view, message, isLong ? 0 : -1);
                            ToastUtil.this.snackbar.show();
                            ToastUtil.this.viewToSnackBarMapping.put(view, ToastUtil.this.snackbar);
                        } else {
                            ToastUtil.this.makeText(AIHelpContext.getInstance().getContext(), message, false);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void hideSnackBar(final View view) {
        if (!AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (view != null) {
                        Snackbar snackbar = (Snackbar)ToastUtil.this.viewToSnackBarMapping.get(view);
                        if (snackbar != null && snackbar.isShown()) {
                            snackbar.dismiss();
                        }
                        ToastUtil.this.viewToSnackBarMapping.remove(view);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void showSnackBar(final Activity activity, final String message, final boolean isLong) {
        if (!AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ToastUtil.this.snackbar != null && ToastUtil.this.snackbar.isShown()) {
                        return;
                    }
                    if (message != null && message.length() != 0) {
                        Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, isLong ? 0 : -1);
                        View snackBarView = snackbar.getView();
                        snackBarView.setBackgroundColor(-1);
                        ((TextView)snackBarView.findViewById(ResResolver.getViewId("snackbar_text"))).setTextColor(Color.parseColor((String)"#1B8AFA"));
                        snackbar.setActionTextColor(Color.parseColor((String)"#1B8AFA"));
                        snackbar.show();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void showSnackBar(final Activity activity, final String message, final String action, final View.OnClickListener listener) {
        if (!AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (message != null && message.length() != 0) {
                        ToastUtil.this.snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, 0).setAction(action, listener);
                        View snackBarView = ToastUtil.this.snackbar.getView();
                        snackBarView.setBackgroundColor(Color.parseColor((String)"#EFF1F6"));
                        ((TextView)snackBarView.findViewById(ResResolver.getViewId("snackbar_text"))).setTextColor(Color.parseColor((String)"#1B8AFA"));
                        ToastUtil.this.snackbar.setActionTextColor(Color.parseColor((String)"#1B8AFA"));
                        ToastUtil.this.snackbar.show();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void showRawSnackBar(final Activity activity, final String message, final int duration) {
        if (!AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (message != null && message.length() != 0) {
                        if (activity != null) {
                            View contentView = activity.getWindow().getDecorView().findViewById(0x1020002);
                            Snackbar.make(contentView, message, duration).show();
                        } else {
                            ToastUtil.this.makeText(AIHelpContext.getInstance().getContext(), message, false);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void showRawSnackBar(final Activity activity, final String message, final String action, final int duration, final View.OnClickListener listener) {
        if (!AIHelpSupport.isAIHelpShowing()) {
            return;
        }
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (message != null && message.length() != 0) {
                        if (activity != null) {
                            View snackBarAction;
                            Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(0x1020002), message, duration).setAction(action, listener);
                            View snackBarText = snackbar.getView().findViewById(ResResolver.getViewId("snackbar_text"));
                            if (snackBarText instanceof TextView) {
                                ((TextView)snackbar.getView().findViewById(ResResolver.getViewId("snackbar_text"))).setMaxLines(4);
                            }
                            if ((snackBarAction = snackbar.getView().findViewById(ResResolver.getViewId("snackbar_action"))) instanceof TextView) {
                                ((TextView)snackbar.getView().findViewById(ResResolver.getViewId("snackbar_action"))).setTextColor(Color.parseColor((String)"#5C7EFF"));
                            }
                            snackbar.show();
                        } else {
                            ToastUtil.this.makeText(AIHelpContext.getInstance().getContext(), message, false);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

