/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.text.TextUtils;
import java.io.File;
import java.util.regex.Pattern;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.UploadCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.init.UploadEntity;
import org.json.JSONArray;
import org.json.JSONObject;

public enum UploadFileHelper {
    INSTANCE;

    private OnUploadFileListener onUploadFileListener;

    public UploadFileHelper setOnUploadFileListener(OnUploadFileListener onUploadFileListener) {
        this.onUploadFileListener = onUploadFileListener;
        return this;
    }

    public void tryUploadLog(boolean isUploadLog) {
        String fileName;
        File file;
        Const.TOGGLE_FETCH_MESSAGE = true;
        if (isUploadLog && Const.TOGGLE_UPLOAD_LOG && !TextUtils.isEmpty((CharSequence)Const.LOG_UPLOAD_PATH) && (file = new File(Const.LOG_UPLOAD_PATH)).exists() && !file.isDirectory() && !TextUtils.isEmpty((CharSequence)(fileName = file.getName()))) {
            AIHelpRequest.getInstance().requestUpLoadFile(API.UPLOAD_LOG_URL, file, new UploadCallback<String>(){

                @Override
                public void onReqSuccess(String result) {
                    try {
                        JSONArray jsonArray = new JSONArray();
                        jsonArray.put((Object)JsonHelper.optString(new JSONObject(result), "data"));
                        AIHelpRequest.getInstance().requestPostByJson(API.UPLOAD_LOG, jsonArray.toString(), null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void performUpload(File file) {
        if (file == null) {
            return;
        }
        final String filePath = file.getPath();
        AIHelpRequest.getInstance().requestUpLoadFile(this.getUploadUrl(filePath), file, new UploadCallback<String>(){

            @Override
            public void onReqSuccess(String result) {
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    String fileUrl = UploadFileHelper.this.getUploadResult(filePath, result);
                    if (UploadFileHelper.this.onUploadFileListener != null) {
                        UploadFileHelper.this.onUploadFileListener.onFileUploaded(fileUrl);
                    }
                }
            }

            @Override
            public void onFailure(String url, int errorCode, String errorMsg) {
                if (UploadFileHelper.this.onUploadFileListener != null) {
                    UploadFileHelper.this.onUploadFileListener.onFileUploaded("");
                }
            }
        });
    }

    private String getUploadUrl(String filePath) {
        if (Pattern.compile("(?i).+\\.(png|jpg|jpeg|gif|heic|bmp)$").matcher(filePath).matches()) {
            return API.UPLOAD_IMAGE_URL;
        }
        if (Pattern.compile("(?i).+\\.(mp4|avi|3gp|mov|mpeg|mpg|m4v|webm|mkv|rmvb|mov|wmv|flv)$").matcher(filePath).matches()) {
            return API.UPLOAD_VIDEO_URL;
        }
        if (filePath.contains("/AIHelp/event/")) {
            return API.UPLOAD_SAMPLING_URL;
        }
        return API.UPLOAD_ATTACHMENT_URL;
    }

    private String getUploadResult(String filePath, String result) {
        if (Pattern.compile("(?i).+\\.(png|jpg|jpeg|gif|heic|bmp)$").matcher(filePath).matches()) {
            UploadEntity.ImageResult imageResult = JsonHelper.toJavaObject(result, UploadEntity.ImageResult.class);
            if (imageResult != null && !TextUtils.isEmpty((CharSequence)imageResult.getUrl())) {
                return imageResult.getUrl();
            }
        } else {
            UploadEntity.FileResult fileResult = JsonHelper.toJavaObject(result, UploadEntity.FileResult.class);
            if (fileResult != null && !TextUtils.isEmpty((CharSequence)fileResult.getData())) {
                return fileResult.getData();
            }
        }
        return "";
    }

    public static interface OnUploadFileListener {
        public void onFileUploaded(String var1);
    }
}

