/*
 * Decompiled with CFR 0.152.
 */
package net.aksingh.owmjapis.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.InetSocketAddress;
import java.net.Proxy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.aksingh.owmjapis.util.OkHttpTools;
import net.aksingh.owmjapis.util.SystemTools;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\rH\u0004J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0000J\u001e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\u001e\u0010\u0011\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J&\u0010\u0011\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J.\u0010\u0011\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\u0004R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lnet/aksingh/owmjapis/core/OWMAlerts;", "", "apiKey", "", "(Ljava/lang/String;)V", "baseUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "value", "getApiKey", "()Ljava/lang/String;", "setApiKey", "getBaseUrl", "setBaseUrl", "Ljava/net/Proxy;", "proxy", "getProxy", "()Ljava/net/Proxy;", "setProxy", "(Ljava/net/Proxy;)V", "retrofit4alerts", "Lretrofit2/Retrofit;", "getRetrofit4alerts", "()Lretrofit2/Retrofit;", "setRetrofit4alerts", "(Lretrofit2/Retrofit;)V", "createRetrofit4AlertsInstance", "createTrigger", "", "resetProxy", "setNoProxy", "user", "pass", "host", "port", "", "type", "Ljava/net/Proxy$Type;", "Companion", "owm-japis"})
public class OWMAlerts {
    @NotNull
    private Retrofit retrofit4alerts;
    @NotNull
    private String baseUrl;
    @NotNull
    private String apiKey;
    @NotNull
    private Proxy proxy;
    private static final String OWM_FREE_V30_BASE_URL = "https://api.openweathermap.org/data/3.0/";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final Retrofit getRetrofit4alerts() {
        return this.retrofit4alerts;
    }

    protected final void setRetrofit4alerts(@NotNull Retrofit retrofit) {
        Intrinsics.checkParameterIsNotNull((Object)retrofit, (String)"<set-?>");
        this.retrofit4alerts = retrofit;
    }

    @NotNull
    protected final String getBaseUrl() {
        return this.baseUrl;
    }

    protected final void setBaseUrl(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.baseUrl = string;
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    public final void setApiKey(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CharSequence charSequence = value;
        boolean bl = false;
        if (charSequence.length() == 0 || StringsKt.isBlank((CharSequence)value)) {
            throw (Throwable)new IllegalArgumentException("API key can't be empty. Get a free API key from OpenWeatherMap.org.");
        }
        this.apiKey = value;
    }

    @NotNull
    public final Proxy getProxy() {
        return this.proxy;
    }

    public final void setProxy(@NotNull Proxy value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.proxy = value;
        this.retrofit4alerts = this.createRetrofit4AlertsInstance(this.proxy);
    }

    @NotNull
    public final OWMAlerts setProxy(@NotNull Proxy proxy, @NotNull String user, @NotNull String pass) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
        SystemTools.Static.setProxyAuthDetails(user, pass);
        this.setProxy(proxy);
        return this;
    }

    @NotNull
    public final OWMAlerts setProxy(@NotNull String host, int port) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.setProxy(host, port, Proxy.Type.HTTP);
        return this;
    }

    @NotNull
    public final OWMAlerts setProxy(@NotNull String host, int port, @NotNull Proxy.Type type) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.setProxy(new Proxy(type, new InetSocketAddress(host, port)));
        this.setProxy(this.proxy);
        return this;
    }

    @NotNull
    public final OWMAlerts setProxy(@NotNull String host, int port, @NotNull String user, @NotNull String pass) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
        this.setProxy(host, port, user, pass, Proxy.Type.HTTP);
        return this;
    }

    @NotNull
    public final OWMAlerts setProxy(@NotNull String host, int port, @NotNull String user, @NotNull String pass, @NotNull Proxy.Type type) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        SystemTools.Static.setProxyAuthDetails(user, pass);
        this.setProxy(host, port, type);
        return this;
    }

    @NotNull
    public final OWMAlerts setNoProxy() {
        Proxy proxy = Proxy.NO_PROXY;
        Intrinsics.checkExpressionValueIsNotNull((Object)proxy, (String)"Proxy.NO_PROXY");
        this.setProxy(proxy);
        return this;
    }

    @NotNull
    public final OWMAlerts resetProxy() {
        SystemTools.Static.setProxyAuthDetails("", "");
        this.setProxy(SystemTools.Static.getSystemProxy());
        return this;
    }

    public final void createTrigger() {
    }

    @NotNull
    protected final Retrofit createRetrofit4AlertsInstance(@NotNull Proxy proxy) {
        OkHttpClient.Builder clientBuilder;
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        OkHttpClient.Builder builder = clientBuilder = new OkHttpClient.Builder().proxy(proxy);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"clientBuilder");
        OkHttpTools.Static.addQueryParameter(builder, "appid", this.apiKey);
        OkHttpClient client = clientBuilder.build();
        Gson gson = new GsonBuilder().setLenient().create();
        Retrofit.Builder builder2 = new Retrofit.Builder().client(client).baseUrl(this.baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson));
        Retrofit retrofit = builder2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"builder.build()");
        return retrofit;
    }

    public OWMAlerts(@NotNull String apiKey) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        this(apiKey, OWM_FREE_V30_BASE_URL);
    }

    protected OWMAlerts(@NotNull String apiKey, @NotNull String baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = OWM_FREE_V30_BASE_URL;
        this.proxy = SystemTools.Static.getSystemProxy();
        this.setApiKey(apiKey);
        this.baseUrl = baseUrl;
        this.retrofit4alerts = this.createRetrofit4AlertsInstance(this.proxy);
    }

    static {
        OWM_FREE_V30_BASE_URL = OWM_FREE_V30_BASE_URL;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/aksingh/owmjapis/core/OWMAlerts$Companion;", "", "()V", "OWM_FREE_V30_BASE_URL", "", "owm-japis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

