/*
 * Decompiled with CFR 0.152.
 */
package net_alchim31_livereload;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net_alchim31_livereload.LRWebSocketHandler;
import net_alchim31_livereload.Watcher;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.resource.Resource;

public class LRServer {
    private final int _port;
    private final Path _docroot;
    private Server _server;
    private Watcher _watcher;
    private static String[] _exclusions;

    public LRServer(int port, Path docroot) {
        this._port = port;
        this._docroot = docroot;
    }

    private void init() throws Exception {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this._port);
        ResourceHandler rHandler = new ResourceHandler(){

            public Resource getResource(String path) throws MalformedURLException {
                if ("/livereload.js".equals(path)) {
                    try {
                        return Resource.newResource((URL)LRServer.class.getResource(path));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                return super.getResource(path);
            }
        };
        rHandler.setDirectoriesListed(true);
        rHandler.setWelcomeFiles(new String[]{"index.html"});
        rHandler.setResourceBase(this._docroot.toString());
        LRWebSocketHandler wsHandler = new LRWebSocketHandler();
        wsHandler.setHandler((Handler)rHandler);
        this._server = new Server();
        this._server.setHandler((Handler)wsHandler);
        this._server.addConnector((Connector)connector);
        this._watcher = new Watcher(this._docroot);
        if (_exclusions != null && _exclusions.length > 0) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String exclusion : _exclusions) {
                patterns.add(Pattern.compile(exclusion));
            }
            this._watcher.set_patterns(patterns);
        }
        this._watcher.listener = wsHandler;
    }

    public static void setExclusions(String[] exclusions) {
        _exclusions = exclusions;
    }

    public static String[] getExclusions() {
        return _exclusions;
    }

    public void start() throws Exception {
        this.init();
        this._server.start();
        this._watcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        try {
            this.start();
            this.join();
        }
        catch (Throwable t) {
            System.err.println("Caught unexpected exception: " + t);
            System.err.println();
            t.printStackTrace(System.err);
        }
        finally {
            this.stop();
        }
    }

    public void join() throws Exception {
        this._server.join();
    }

    public void stop() throws Exception {
        this._watcher.stop();
        this._server.stop();
    }
}

