/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_model;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectAdapter {
    final MavenProject wrapped;

    public MavenProjectAdapter(MavenProject project) {
        this.wrapped = project;
    }

    public List<Profile> getActiveProfiles() {
        return this.wrapped.getActiveProfiles();
    }

    public Map<String, Artifact> getArtifactMap() {
        return this.wrapped.getArtifactMap();
    }

    public Set<Artifact> getArtifacts() {
        return this.wrapped.getArtifacts();
    }

    public List<Artifact> getAttachedArtifacts() {
        return this.wrapped.getAttachedArtifacts();
    }

    public List<Plugin> getBuildPlugins() {
        return this.wrapped.getBuildPlugins();
    }

    public List<MavenProject> getCollectedProjects() {
        return this.wrapped.getCollectedProjects();
    }

    public List<Artifact> getCompileArtifacts() {
        return this.wrapped.getCompileArtifacts();
    }

    public List<String> getCompileClasspathElements() throws DependencyResolutionRequiredException {
        return this.wrapped.getCompileClasspathElements();
    }

    public List<Dependency> getCompileDependencies() {
        return this.wrapped.getCompileDependencies();
    }

    public List<String> getCompileSourceRoots() {
        return this.wrapped.getCompileSourceRoots();
    }

    public List<Contributor> getContributors() {
        return this.wrapped.getContributors();
    }

    public List<Dependency> getDependencies() {
        return this.wrapped.getDependencies();
    }

    public Set<Artifact> getDependencyArtifacts() {
        return this.wrapped.getDependencyArtifacts();
    }

    public List<Developer> getDevelopers() {
        return this.wrapped.getDevelopers();
    }

    public Map<String, Artifact> getExtensionArtifactMap() {
        return this.wrapped.getExtensionArtifactMap();
    }

    public Set<Artifact> getExtensionArtifacts() {
        return this.wrapped.getExtensionArtifacts();
    }

    public List<String> getFilters() {
        return this.wrapped.getFilters();
    }

    public List<License> getLicenses() {
        return this.wrapped.getLicenses();
    }

    public List<MailingList> getMailingLists() {
        return this.wrapped.getMailingLists();
    }

    public Map getManagedVersionMap() {
        return this.wrapped.getManagedVersionMap();
    }

    public List<String> getModules() {
        return this.wrapped.getModules();
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        return this.wrapped.getPluginArtifactMap();
    }

    public List<ArtifactRepository> getPluginArtifactRepositories() {
        return this.wrapped.getPluginArtifactRepositories();
    }

    public Set<Artifact> getPluginArtifacts() {
        return this.wrapped.getPluginArtifacts();
    }

    public List<Repository> getPluginRepositories() {
        return this.wrapped.getPluginRepositories();
    }

    public Map<String, MavenProject> getProjectReferences() {
        return this.wrapped.getProjectReferences();
    }

    public List<ArtifactRepository> getRemoteArtifactRepositories() {
        return this.wrapped.getRemoteArtifactRepositories();
    }

    public Map<String, Artifact> getReportArtifactMap() {
        return this.wrapped.getReportArtifactMap();
    }

    public Set<Artifact> getReportArtifacts() {
        return this.wrapped.getReportArtifacts();
    }

    public List<Plugin> getReportPlugins() {
        return this.wrapped.getReportPlugins();
    }

    public List<Repository> getRepositories() {
        return this.wrapped.getRepositories();
    }

    public List<Resource> getResources() {
        return this.wrapped.getResources();
    }

    public List<Artifact> getRuntimeArtifacts() {
        return this.wrapped.getRuntimeArtifacts();
    }

    public List<String> getRuntimeClasspathElements() throws DependencyResolutionRequiredException {
        return this.wrapped.getRuntimeClasspathElements();
    }

    public List<Dependency> getRuntimeDependencies() {
        return this.wrapped.getRuntimeDependencies();
    }

    public List<String> getScriptSourceRoots() {
        return this.wrapped.getScriptSourceRoots();
    }

    public List<Artifact> getSystemArtifacts() {
        return this.wrapped.getSystemArtifacts();
    }

    public List<String> getSystemClasspathElements() throws DependencyResolutionRequiredException {
        return this.wrapped.getSystemClasspathElements();
    }

    public List<Dependency> getSystemDependencies() {
        return this.wrapped.getSystemDependencies();
    }

    public List<Artifact> getTestArtifacts() {
        return this.wrapped.getTestArtifacts();
    }

    public List<String> getTestClasspathElements() throws DependencyResolutionRequiredException {
        return this.wrapped.getTestClasspathElements();
    }

    public List<String> getTestCompileSourceRoots() {
        return this.wrapped.getTestCompileSourceRoots();
    }

    public List<Dependency> getTestDependencies() {
        return this.wrapped.getTestDependencies();
    }

    public List<Resource> getTestResources() {
        return this.wrapped.getTestResources();
    }

    public String apply(String key) {
        if (key == null) {
            return null;
        }
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        if (System.getenv(key) != null) {
            return System.getenv(key);
        }
        if (key.equals("build.directory") || key.equals("project.build.directory") || key.equals("buildDirectory") || key.equals("project.buildDirectory")) {
            return this.getBuild().getDirectory();
        }
        if (key.equals("outputDirectory") || key.equals("project.outputDirectory") || key.equals("output.directory") || key.equals("project.output.directory")) {
            return this.getBuild().getOutputDirectory();
        }
        if (key.equals("artifactId") || key.equals("project.artifactId")) {
            return this.getArtifactId();
        }
        if (key.equals("basedir") || key.equals("project.basedir")) {
            return this.getBasedir().getAbsolutePath();
        }
        if (key.equals("defaultGoal") || key.equals("project.defaultGoal")) {
            return this.getBuild().getDefaultGoal();
        }
        if (key.equals("finalName") || key.equals("project.finalName")) {
            return this.getBuild().getFinalName();
        }
        if (key.equals("scriptSourceDirectory") || key.equals("project.scriptSourceDirectory") || key.equals("script.source.directory") || key.equals("project.script.source.directory")) {
            return this.getBuild().getScriptSourceDirectory();
        }
        if (key.equals("source.directory") || key.equals("project.source.directory") || key.equals("sourceDirectory") || key.equals("project.sourceDirectory")) {
            return this.getBuild().getSourceDirectory();
        }
        if (key.equals("test.output.directory") || key.equals("project.test.output.directory") || key.equals("testOutputDirectory") || key.equals("project.testOutputDirectory")) {
            return this.getBuild().getTestOutputDirectory();
        }
        if (key.equals("test.source.directory") || key.equals("project.test.source.directory") || key.equals("testSourceDirectory") || key.equals("project.testSourceDirectory")) {
            return this.getBuild().getTestSourceDirectory();
        }
        if (key.equals("directory") || key.equals("project.directory")) {
            return this.getDescription();
        }
        if (key.equals("pom")) {
            return this.getFile().getAbsolutePath();
        }
        if (key.equals("groupId") || key.equals("project.groupId")) {
            return this.getGroupId();
        }
        if (key.equals("id") || key.equals("project.id")) {
            return this.getId();
        }
        if (key.equals("inception") || key.equals("project.inception") || key.equals("inceptionYear") || key.equals("project.inceptionYear") || key.equals("inception.year") || key.equals("project.inception.year")) {
            return this.getInceptionYear();
        }
        if (key.equals("name") || key.equals("project.name")) {
            return this.getName();
        }
        if (key.equals("packaging") || key.equals("project.packaging")) {
            return this.getModel().getPackaging();
        }
        if (key.equals("url") || key.equals("project.url")) {
            return this.getModel().getUrl();
        }
        if (key.equals("version") || key.equals("project.version")) {
            return this.getModel().getVersion();
        }
        return this.wrapped.getProperties().getProperty(key);
    }

    public String apply(String key, String defaultValue) {
        String result = this.apply(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public void update(String key, String value) {
        if (key.equals("build.directory") || key.equals("project.build.directory") || key.equals("buildDirectory") || key.equals("project.buildDirectory")) {
            this.getBuild().setDirectory(value);
        } else if (key.equals("outputDirectory") || key.equals("project.outputDirectory") || key.equals("output.directory") || key.equals("project.output.directory")) {
            this.getBuild().setOutputDirectory(value);
        } else if (key.equals("artifactId") || key.equals("project.artifactId")) {
            this.setArtifactId(value);
        } else if (key.equals("defaultGoal") || key.equals("project.defaultGoal")) {
            this.getBuild().setDefaultGoal(value);
        } else if (key.equals("finalName") || key.equals("project.finalName")) {
            this.getBuild().setFinalName(value);
        } else if (key.equals("scriptSourceDirectory") || key.equals("project.scriptSourceDirectory") || key.equals("script.source.directory") || key.equals("project.script.source.directory")) {
            this.getBuild().setScriptSourceDirectory(value);
        } else if (key.equals("source.directory") || key.equals("project.source.directory") || key.equals("sourceDirectory") || key.equals("project.sourceDirectory")) {
            this.getBuild().setSourceDirectory(value);
        } else if (key.equals("test.output.directory") || key.equals("project.test.output.directory") || key.equals("testOutputDirectory") || key.equals("project.testOutputDirectory")) {
            this.getBuild().setTestOutputDirectory(value);
        } else if (key.equals("test.source.directory") || key.equals("project.test.source.directory") || key.equals("testSourceDirectory") || key.equals("project.testSourceDirectory")) {
            this.getBuild().setTestSourceDirectory(value);
        } else if (key.equals("directory") || key.equals("project.directory")) {
            this.setDescription(value);
        } else if (key.equals("pom")) {
            this.setFile(new File(value));
        } else if (key.equals("groupId") || key.equals("project.groupId")) {
            this.setGroupId(value);
        } else if (key.equals("inception") || key.equals("project.inception") || key.equals("inceptionYear") || key.equals("project.inceptionYear") || key.equals("inception.year") || key.equals("project.inception.year")) {
            this.setInceptionYear(value);
        } else if (key.equals("name") || key.equals("project.name")) {
            this.setName(value);
        } else if (key.equals("packaging") || key.equals("project.packaging")) {
            this.getModel().setPackaging(value);
        } else if (key.equals("url") || key.equals("project.url")) {
            this.getModel().setUrl(value);
        } else if (key.equals("version") || key.equals("project.version")) {
            this.getModel().setVersion(value);
        } else {
            this.wrapped.getProperties().setProperty(key, value);
        }
    }

    public void update(String key, int value) {
        this.update(key, String.valueOf(value));
    }

    public void update(String key, boolean value) {
        this.update(key, String.valueOf(value));
    }

    public void update(String key, double value) {
        this.update(key, String.valueOf(value));
    }

    public void update(String key, long value) {
        this.update(key, String.valueOf(value));
    }

    public void update(String key, char value) {
        this.update(key, String.valueOf(value));
    }

    public void update(String key, float value) {
        this.update(key, String.valueOf(value));
    }

    public void update(String key, byte value) {
        this.update(key, String.valueOf(value));
    }

    public void addAttachedArtifact(Artifact artifact) {
        this.wrapped.addAttachedArtifact(artifact);
    }

    public void addCompileSourceRoot(String path) {
        this.wrapped.addCompileSourceRoot(path);
    }

    public void addContributor(Contributor contributor) {
        this.wrapped.addContributor(contributor);
    }

    public void addDeveloper(Developer developer) {
        this.wrapped.addDeveloper(developer);
    }

    public void addLicense(License license) {
        this.wrapped.addLicense(license);
    }

    public void addMailingList(MailingList mailingList) {
        this.wrapped.addMailingList(mailingList);
    }

    public void addPlugin(Plugin plugin) {
        this.wrapped.addPlugin(plugin);
    }

    public void addProjectReference(MavenProject project) {
        this.wrapped.addProjectReference(project);
    }

    public void addResource(Resource resource) {
        this.wrapped.addResource(resource);
    }

    public void addScriptSourceRoot(String path) {
        this.wrapped.addScriptSourceRoot(path);
    }

    public void addTestCompileSourceRoot(String path) {
        this.wrapped.addTestCompileSourceRoot(path);
    }

    public void addTestResource(Resource testResource) {
        this.wrapped.addTestResource(testResource);
    }

    public Set<Artifact> createArtifacts(ArtifactFactory artifactFactory, String inheritedScope, ArtifactFilter dependencyFilter) throws InvalidDependencyVersionException {
        return this.wrapped.createArtifacts(artifactFactory, inheritedScope, dependencyFilter);
    }

    public boolean equals(Object arg0) {
        return this.wrapped.equals(arg0);
    }

    public Artifact getArtifact() {
        return this.wrapped.getArtifact();
    }

    public String getArtifactId() {
        return this.wrapped.getArtifactId();
    }

    public File getBasedir() {
        return this.wrapped.getBasedir();
    }

    public Build getBuild() {
        return this.wrapped.getBuild();
    }

    public List getBuildExtensions() {
        return this.wrapped.getBuildExtensions();
    }

    public CiManagement getCiManagement() {
        return this.wrapped.getCiManagement();
    }

    public String getDefaultGoal() {
        return this.wrapped.getDefaultGoal();
    }

    public DependencyManagement getDependencyManagement() {
        return this.wrapped.getDependencyManagement();
    }

    public String getDescription() {
        return this.wrapped.getDescription();
    }

    public DistributionManagement getDistributionManagement() {
        return this.wrapped.getDistributionManagement();
    }

    public ArtifactRepository getDistributionManagementArtifactRepository() {
        return this.wrapped.getDistributionManagementArtifactRepository();
    }

    public MavenProject getExecutionProject() {
        return this.wrapped.getExecutionProject();
    }

    public File getFile() {
        return this.wrapped.getFile();
    }

    public Xpp3Dom getGoalConfiguration(String arg0, String arg1, String arg2, String arg3) {
        return this.wrapped.getGoalConfiguration(arg0, arg1, arg2, arg3);
    }

    public String getGroupId() {
        return this.wrapped.getGroupId();
    }

    public String getId() {
        return this.wrapped.getId();
    }

    public String getInceptionYear() {
        return this.wrapped.getInceptionYear();
    }

    public IssueManagement getIssueManagement() {
        return this.wrapped.getIssueManagement();
    }

    public Model getModel() {
        return this.wrapped.getModel();
    }

    public String getModelVersion() {
        return this.wrapped.getModelVersion();
    }

    public String getModulePathAdjustment(MavenProject arg0) throws IOException {
        return this.wrapped.getModulePathAdjustment(arg0);
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public Organization getOrganization() {
        return this.wrapped.getOrganization();
    }

    public Model getOriginalModel() {
        return this.wrapped.getOriginalModel();
    }

    public String getPackaging() {
        return this.wrapped.getPackaging();
    }

    public MavenProject getParent() {
        return this.wrapped.getParent();
    }

    public Artifact getParentArtifact() {
        return this.wrapped.getParentArtifact();
    }

    public PluginManagement getPluginManagement() {
        return this.wrapped.getPluginManagement();
    }

    public Prerequisites getPrerequisites() {
        return this.wrapped.getPrerequisites();
    }

    public Properties getProperties() {
        return this.wrapped.getProperties();
    }

    public Xpp3Dom getReportConfiguration(String arg0, String arg1, String arg2) {
        return this.wrapped.getReportConfiguration(arg0, arg1, arg2);
    }

    public Reporting getReporting() {
        return this.wrapped.getReporting();
    }

    public Scm getScm() {
        return this.wrapped.getScm();
    }

    public String getUrl() {
        return this.wrapped.getUrl();
    }

    public String getVersion() {
        return this.wrapped.getVersion();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean hasParent() {
        return this.wrapped.hasParent();
    }

    public void injectPluginManagementInfo(Plugin arg0) {
        this.wrapped.injectPluginManagementInfo(arg0);
    }

    public boolean isExecutionRoot() {
        return this.wrapped.isExecutionRoot();
    }

    public Artifact replaceWithActiveArtifact(Artifact arg0) {
        return this.wrapped.replaceWithActiveArtifact(arg0);
    }

    public void setActiveProfiles(List<Profile> activeProfiles) {
        this.wrapped.setActiveProfiles(activeProfiles);
    }

    public void setArtifact(Artifact artifact) {
        this.wrapped.setArtifact(artifact);
    }

    public void setArtifactId(String artifactId) {
        this.wrapped.setArtifactId(artifactId);
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.wrapped.setArtifacts(artifacts);
    }

    public void setBuild(Build build) {
        this.wrapped.setBuild(build);
    }

    public void setCiManagement(CiManagement ciManagement) {
        this.wrapped.setCiManagement(ciManagement);
    }

    public void setCollectedProjects(List<MavenProject> collectedProjects) {
        this.wrapped.setCollectedProjects(collectedProjects);
    }

    public void setContributors(List<Contributor> contributors) {
        this.wrapped.setContributors(contributors);
    }

    public void setDependencies(List dependencies) {
        this.wrapped.setDependencies(dependencies);
    }

    public void setDependencyArtifacts(Set dependencyArtifacts) {
        this.wrapped.setDependencyArtifacts(dependencyArtifacts);
    }

    public void setDescription(String description) {
        this.wrapped.setDescription(description);
    }

    public void setDevelopers(List developers) {
        this.wrapped.setDevelopers(developers);
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.wrapped.setDistributionManagement(distributionManagement);
    }

    public void setExecutionProject(MavenProject executionProject) {
        this.wrapped.setExecutionProject(executionProject);
    }

    public void setExecutionRoot(boolean executionRoot) {
        this.wrapped.setExecutionRoot(executionRoot);
    }

    public void setExtensionArtifacts(Set extensionArtifacts) {
        this.wrapped.setExtensionArtifacts(extensionArtifacts);
    }

    public void setFile(File file) {
        this.wrapped.setFile(file);
    }

    public void setGroupId(String groupId) {
        this.wrapped.setGroupId(groupId);
    }

    public void setInceptionYear(String inceptionYear) {
        this.wrapped.setInceptionYear(inceptionYear);
    }

    public void setIssueManagement(IssueManagement issueManagement) {
        this.wrapped.setIssueManagement(issueManagement);
    }

    public void setLicenses(List licenses) {
        this.wrapped.setLicenses(licenses);
    }

    public void setMailingLists(List mailingLists) {
        this.wrapped.setMailingLists(mailingLists);
    }

    public void setManagedVersionMap(Map map) {
        this.wrapped.setManagedVersionMap(map);
    }

    public void setModelVersion(String pomVersion) {
        this.wrapped.setModelVersion(pomVersion);
    }

    public void setName(String name) {
        this.wrapped.setName(name);
    }

    public void setOrganization(Organization organization) {
        this.wrapped.setOrganization(organization);
    }

    public void setOriginalModel(Model originalModel) {
        this.wrapped.setOriginalModel(originalModel);
    }

    public void setPackaging(String packaging) {
        this.wrapped.setPackaging(packaging);
    }

    public void setParent(MavenProject parent) {
        this.wrapped.setParent(parent);
    }

    public void setParentArtifact(Artifact parentArtifact) {
        this.wrapped.setParentArtifact(parentArtifact);
    }

    public void setPluginArtifactRepositories(List pluginArtifactRepositories) {
        this.wrapped.setPluginArtifactRepositories(pluginArtifactRepositories);
    }

    public void setPluginArtifacts(Set pluginArtifacts) {
        this.wrapped.setPluginArtifacts(pluginArtifacts);
    }

    public void setReleaseArtifactRepository(ArtifactRepository releaseArtifactRepository) {
        this.wrapped.setReleaseArtifactRepository(releaseArtifactRepository);
    }

    public void setRemoteArtifactRepositories(List remoteArtifactRepositories) {
        this.wrapped.setRemoteArtifactRepositories(remoteArtifactRepositories);
    }

    public void setReportArtifacts(Set reportArtifacts) {
        this.wrapped.setReportArtifacts(reportArtifacts);
    }

    public void setReporting(Reporting reporting) {
        this.wrapped.setReporting(reporting);
    }

    public void setScm(Scm scm) {
        this.wrapped.setScm(scm);
    }

    public void setSnapshotArtifactRepository(ArtifactRepository snapshotArtifactRepository) {
        this.wrapped.setSnapshotArtifactRepository(snapshotArtifactRepository);
    }

    public void setUrl(String url) {
        this.wrapped.setUrl(url);
    }

    public void setVersion(String version) {
        this.wrapped.setVersion(version);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public void writeModel(Writer writer) throws IOException {
        this.wrapped.writeModel(writer);
    }

    public void writeOriginalModel(Writer writer) throws IOException {
        this.wrapped.writeOriginalModel(writer);
    }

    public MavenProject getWrapped() {
        return this.wrapped;
    }
}

