/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import scala_maven.FileUtils;
import scala_maven.ScalaMojoSupport;
import scala_maven_executions.MainHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalaSourceMojoSupport
extends ScalaMojoSupport {
    protected boolean sendJavaToScalac = true;
    protected Set<String> includes = new HashSet<String>();
    protected Set<String> excludes = new HashSet<String>();
    private boolean _filterPrinted = false;

    protected abstract List<File> getSourceDirectories() throws Exception;

    protected List<File> findSourceWithFilters() throws Exception {
        return this.findSourceWithFilters(this.getSourceDirectories());
    }

    protected void initFilters() throws Exception {
        if (this.includes.isEmpty()) {
            this.includes.add("**/*.scala");
            if (this.sendJavaToScalac && this.isJavaSupportedByCompiler()) {
                this.includes.add("**/*.java");
            }
        }
        if (!this._filterPrinted && this.getLog().isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("includes = [");
            for (String include : this.includes) {
                builder.append(include).append(",");
            }
            builder.append("]");
            this.getLog().debug((CharSequence)builder.toString());
            builder = new StringBuilder("excludes = [");
            for (String exclude : this.excludes) {
                builder.append(exclude).append(",");
            }
            builder.append("]");
            this.getLog().debug((CharSequence)builder.toString());
            this._filterPrinted = true;
        }
    }

    protected List<File> findSourceWithFilters(List<File> sourceRootDirs) throws Exception {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        this.initFilters();
        for (File dir : sourceRootDirs) {
            String[] tmpFiles;
            for (String tmpLocalFile : tmpFiles = MainHelper.findFiles(dir, this.includes.toArray(new String[this.includes.size()]), this.excludes.toArray(new String[this.excludes.size()]))) {
                File tmpAbsFile = FileUtils.fileOf(new File(dir, tmpLocalFile), this.useCanonicalPath);
                sourceFiles.add(tmpAbsFile);
            }
        }
        Collections.sort(sourceFiles);
        return sourceFiles;
    }

    protected List<File> normalize(List<String> compileSourceRootsList) throws Exception {
        ArrayList<File> newCompileSourceRootsList = new ArrayList<File>();
        if (compileSourceRootsList != null) {
            for (String srcDir : compileSourceRootsList) {
                File srcDirFile = FileUtils.fileOf(new File(srcDir), this.useCanonicalPath);
                if (newCompileSourceRootsList.contains(srcDirFile) || !srcDirFile.exists()) continue;
                newCompileSourceRootsList.add(srcDirFile);
            }
        }
        return newCompileSourceRootsList;
    }
}

