/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.BasicArtifact;
import scala_maven.FileUtils;
import scala_maven.VersionNumber;
import scala_maven_dependency.CheckScalaVersionVisitor;
import scala_maven_dependency.ScalaDistroArtifactFilter;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.JavaMainCallerByFork;
import scala_maven_executions.JavaMainCallerInProcess;
import scala_maven_executions.JavaMainCallerSupport;
import scala_maven_executions.MainHelper;

public abstract class ScalaMojoSupport
extends AbstractMojo {
    public static final String SCALA_GROUPID = "org.scala-lang";
    public static final String SCALA_LIBRARY_ARTIFACTID = "scala-library";
    public static final String SCALA_COMPILER_ARTIFACTID = "scala-compiler";
    protected MavenProject project;
    protected MavenSession session;
    protected List<MavenProject> reactorProjects;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected ArtifactRepository localRepo;
    protected List<?> remoteRepos;
    protected BasicArtifact[] dependencies;
    protected BasicArtifact[] compilerPlugins;
    protected String[] jvmArgs;
    protected String[] args;
    protected String addScalacArgs;
    protected String scalaClassName;
    private String scalaVersion;
    protected String[] javacArgs;
    protected String addJavacArgs;
    public boolean displayCmd;
    protected boolean fork = true;
    protected boolean forceUseArgFile = false;
    protected boolean checkMultipleScalaVersions;
    protected boolean failOnMultipleScalaVersions = false;
    protected boolean useCanonicalPath = true;
    protected MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    protected ToolchainManager toolchainManager;
    private List<Artifact> pluginArtifacts;
    private VersionNumber _scalaVersionN;

    protected Set<Artifact> resolveDependencyArtifacts(MavenProject theProject) throws Exception {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter("test"));
        filter.add(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !artifact.isOptional();
            }
        });
        Set artifacts = theProject.createArtifacts(this.factory, "runtime", (ArtifactFilter)filter);
        for (Artifact artifact : artifacts) {
            this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        }
        return artifacts;
    }

    protected Set<Artifact> resolveArtifactDependencies(Artifact artifact) throws Exception {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.localRepo);
        return this.resolveDependencyArtifacts(pomProject);
    }

    public void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath) throws Exception {
        this.addToClasspath(groupId, artifactId, version, classpath, true);
    }

    public void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath, boolean addDependencies) throws Exception {
        this.addToClasspath(this.factory.createArtifact(groupId, artifactId, version, "runtime", "jar"), classpath, addDependencies);
    }

    public void addToClasspath(String groupId, String artifactId, String version, String classifier, Set<String> classpath, boolean addDependencies) throws Exception {
        this.addToClasspath(this.factory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "jar", classifier, "runtime"), classpath, addDependencies);
    }

    protected void addToClasspath(Artifact artifact, Set<String> classpath, boolean addDependencies) throws Exception {
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        classpath.add(FileUtils.pathOf(artifact.getFile(), this.useCanonicalPath));
        if (addDependencies) {
            for (Artifact dep : this.resolveArtifactDependencies(artifact)) {
                this.addToClasspath(dep, classpath, addDependencies);
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String oldWay = System.getProperty("maven.scala.version");
            if (oldWay != null) {
                this.getLog().warn((CharSequence)"using 'maven.scala.version' is deprecated, use 'scala.version' instead");
                if (this.scalaVersion != null) {
                    this.scalaVersion = oldWay;
                }
            }
            if ((oldWay = System.getProperty("maven.scala.displayCmd")) != null) {
                this.getLog().warn((CharSequence)"using 'maven.scala.displayCmd' is deprecated, use 'displayCmd' instead");
                this.displayCmd = this.displayCmd || Boolean.parseBoolean(oldWay);
            }
            this.checkScalaVersion();
            this.doExecute();
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (MojoFailureException exc) {
            throw exc;
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc, exc);
        }
    }

    protected List<Dependency> getDependencies() {
        return this.project.getCompileDependencies();
    }

    protected VersionNumber findScalaVersion() throws Exception {
        if (this._scalaVersionN == null) {
            String detectedScalaVersion = this.scalaVersion;
            if (StringUtils.isEmpty((String)detectedScalaVersion)) {
                detectedScalaVersion = this.findScalaVersionFromDependencies();
            }
            if (StringUtils.isEmpty((String)detectedScalaVersion)) {
                if (!"pom".equals(this.project.getPackaging().toLowerCase())) {
                    this.getLog().warn((CharSequence)"you don't define org.scala-lang:scala-library as a dependency of the project");
                }
                detectedScalaVersion = "0.0.0";
            } else {
                boolean isSnapshot = ArtifactUtils.isSnapshot((String)detectedScalaVersion);
                if (isSnapshot && !detectedScalaVersion.endsWith("-SNAPSHOT")) {
                    detectedScalaVersion = detectedScalaVersion.substring(0, detectedScalaVersion.lastIndexOf(45, detectedScalaVersion.lastIndexOf(45) - 1)) + "-SNAPSHOT";
                }
            }
            if (StringUtils.isEmpty((String)detectedScalaVersion)) {
                throw new MojoFailureException("no scalaVersion detected or set");
            }
            if (StringUtils.isNotEmpty((String)this.scalaVersion) && !this.scalaVersion.equals(detectedScalaVersion)) {
                this.getLog().warn((CharSequence)"scala library version define in dependencies doesn't match the scalaVersion of the plugin");
            }
            this._scalaVersionN = new VersionNumber(detectedScalaVersion);
        }
        return this._scalaVersionN;
    }

    private String findScalaVersionFromDependencies() throws Exception {
        return this.findVersionFromDependencies(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID);
    }

    protected String findVersionFromDependencies(String groupId, String artifactId) throws Exception {
        String version = null;
        for (Dependency dep : this.getDependencies()) {
            if (!groupId.equals(dep.getGroupId()) || !artifactId.equals(dep.getArtifactId())) continue;
            version = dep.getVersion();
        }
        if (StringUtils.isEmpty(version)) {
            ArrayList deps = new ArrayList();
            deps.addAll(this.project.getModel().getDependencies());
            if (this.project.getModel().getDependencyManagement() != null) {
                deps.addAll(this.project.getModel().getDependencyManagement().getDependencies());
            }
            for (Dependency dep : deps) {
                if (!groupId.equals(dep.getGroupId()) || !artifactId.equals(dep.getArtifactId())) continue;
                version = dep.getVersion();
            }
        }
        return version;
    }

    protected void checkScalaVersion() throws Exception {
        if (this.checkMultipleScalaVersions) {
            this.checkCorrectVersionsOfScalaLibrary(this.findScalaVersion().toString());
        }
    }

    private void checkCorrectVersionsOfScalaLibrary(String requiredScalaVersion) throws Exception {
        this.getLog().debug((CharSequence)"Checking for multiple versions of scala");
        this.checkArtifactForScalaVersion(requiredScalaVersion, this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector));
    }

    private void checkArtifactForScalaVersion(String requiredScalaVersion, DependencyNode rootNode) throws Exception {
        CheckScalaVersionVisitor visitor = new CheckScalaVersionVisitor(requiredScalaVersion, this.getLog());
        CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
        FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, this.createScalaDistroDependencyFilter());
        rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
        AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
        FilteringDependencyNodeVisitor filteredVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)secondPassFilter);
        rootNode.accept((DependencyNodeVisitor)filteredVisitor);
        if (visitor.isFailed()) {
            visitor.logScalaDependents();
            if (this.failOnMultipleScalaVersions) {
                this.getLog().error((CharSequence)"Multiple versions of scala libraries detected!");
                throw new MojoFailureException("Multiple versions of scala libraries detected!");
            }
            this.getLog().warn((CharSequence)"Multiple versions of scala libraries detected!");
        }
    }

    private DependencyNodeFilter createScalaDistroDependencyFilter() {
        ArrayList<ScalaDistroArtifactFilter> filters = new ArrayList<ScalaDistroArtifactFilter>();
        filters.add(new ScalaDistroArtifactFilter());
        return new AndDependencyNodeFilter(filters);
    }

    protected abstract void doExecute() throws Exception;

    protected JavaMainCaller getScalaCommand() throws Exception {
        JavaMainCaller cmd = this.getEmptyScalaCommand(this.scalaClassName);
        cmd.addArgs(this.args);
        if (StringUtils.isNotEmpty((String)this.addScalacArgs)) {
            cmd.addArgs(StringUtils.split((String)this.addScalacArgs, (String)"|"));
        }
        this.addCompilerPluginOptions(cmd);
        cmd.addJvmArgs(this.jvmArgs);
        return cmd;
    }

    protected JavaMainCaller getEmptyScalaCommand(String mainClass) throws Exception {
        JavaMainCallerSupport cmd;
        if (this.fork) {
            this.getLog().debug((CharSequence)("use java command with args in file forced : " + this.forceUseArgFile));
            cmd = new JavaMainCallerByFork(this, mainClass, this.getToolClasspath(), null, null, this.forceUseArgFile, this.toolchainManager.getToolchainFromBuildContext("jdk", this.session));
        } else {
            cmd = new JavaMainCallerInProcess(this, mainClass, this.getToolClasspath(), null, null);
        }
        cmd.addJvmArgs("-Xbootclasspath/a:" + this.getBootClasspath());
        return cmd;
    }

    private String getToolClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath(SCALA_GROUPID, SCALA_COMPILER_ARTIFACTID, this.findScalaVersion().toString(), classpath);
        if (this.dependencies != null) {
            for (BasicArtifact artifact : this.dependencies) {
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, classpath);
            }
        }
        return MainHelper.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    private String getBootClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, this.findScalaVersion().toString(), classpath);
        this.addToClasspath(SCALA_GROUPID, SCALA_COMPILER_ARTIFACTID, this.findScalaVersion().toString(), classpath);
        return MainHelper.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    protected List<String> getScalaOptions() throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        if (this.args != null) {
            Collections.addAll(options, this.args);
        }
        if (StringUtils.isNotEmpty((String)this.addScalacArgs)) {
            Collections.addAll(options, StringUtils.split((String)this.addScalacArgs, (String)"|"));
        }
        options.addAll(this.getCompilerPluginOptions());
        return options;
    }

    protected List<String> getJavacOptions() throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        if (this.javacArgs != null) {
            Collections.addAll(options, this.javacArgs);
        }
        if (StringUtils.isNotEmpty((String)this.addJavacArgs)) {
            Collections.addAll(options, StringUtils.split((String)this.addJavacArgs, (String)"|"));
        }
        return options;
    }

    protected File getLibraryJar() throws Exception {
        return this.getArtifactJar(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, this.findScalaVersion().toString());
    }

    protected File getCompilerJar() throws Exception {
        return this.getArtifactJar(SCALA_GROUPID, SCALA_COMPILER_ARTIFACTID, this.findScalaVersion().toString());
    }

    protected List<File> getCompilerDependencies() throws Exception {
        ArrayList<File> d = new ArrayList<File>();
        for (Artifact artifact : this.getAllDependencies(SCALA_GROUPID, SCALA_COMPILER_ARTIFACTID, this.findScalaVersion().toString())) {
            d.add(artifact.getFile());
        }
        return d;
    }

    protected File getArtifactJar(String groupId, String artifactId, String version) throws Exception {
        Artifact artifact = this.factory.createArtifact(groupId, artifactId, version, "runtime", "jar");
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        return artifact.getFile();
    }

    protected File getArtifactJar(String groupId, String artifactId, String version, String classifier) throws Exception {
        Artifact artifact = this.factory.createArtifactWithClassifier(groupId, artifactId, version, "jar", classifier);
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        return artifact.getFile();
    }

    protected Set<Artifact> getAllDependencies(String groupId, String artifactId, String version) throws Exception {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Artifact pom = this.factory.createArtifact(groupId, artifactId, version, "", "pom");
        MavenProject p = this.mavenProjectBuilder.buildFromRepository(pom, this.remoteRepos, this.localRepo);
        Set<Artifact> d = this.resolveDependencyArtifacts(p);
        result.addAll(d);
        for (Artifact dependency : d) {
            Set<Artifact> transitive = this.getAllDependencies(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            result.addAll(transitive);
        }
        return result;
    }

    protected boolean isJavaSupportedByCompiler() throws Exception {
        return this.findScalaVersion().compareTo(new VersionNumber("2.7.2")) >= 0;
    }

    protected void addCompilerPluginOptions(JavaMainCaller scalac) throws Exception {
        for (String option : this.getCompilerPluginOptions()) {
            scalac.addArgs(option);
        }
    }

    protected List<String> getCompilerPluginOptions() throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        for (String plugin : this.getCompilerPlugins()) {
            options.add("-Xplugin:" + plugin);
        }
        return options;
    }

    private Set<String> getCompilerPlugins() throws Exception {
        HashSet<String> plugins = new HashSet<String>();
        if (this.compilerPlugins != null) {
            HashSet<String> ignoreClasspath = new HashSet<String>();
            String sv = this.findScalaVersion().toString();
            this.addToClasspath(SCALA_GROUPID, SCALA_COMPILER_ARTIFACTID, sv, ignoreClasspath);
            this.addToClasspath(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, sv, ignoreClasspath);
            for (BasicArtifact artifact : this.compilerPlugins) {
                this.getLog().info((CharSequence)("compiler plugin: " + artifact.toString()));
                HashSet<String> pluginClassPath = new HashSet<String>();
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, artifact.classifier, pluginClassPath, false);
                pluginClassPath.removeAll(ignoreClasspath);
                plugins.addAll(pluginClassPath);
            }
        }
        return plugins;
    }

    protected String findVersionFromPluginArtifacts(String groupId, String artifactId) throws Exception {
        String version = null;
        for (Artifact art : this.pluginArtifacts) {
            if (!groupId.equals(art.getGroupId()) || !artifactId.equals(art.getArtifactId())) continue;
            version = art.getVersion();
        }
        return version;
    }

    protected File getPluginArtifactJar(String groupId, String artifactId, String version) throws Exception {
        return this.getPluginArtifactJar(groupId, artifactId, version, null);
    }

    protected File getPluginArtifactJar(String groupId, String artifactId, String version, String classifier) throws Exception {
        Artifact artifact = null;
        for (Artifact art : this.pluginArtifacts) {
            if (!groupId.equals(art.getGroupId()) || !artifactId.equals(art.getArtifactId()) || !version.equals(art.getVersion()) || (classifier != null || art.getClassifier() != null) && (classifier == null || !classifier.equals(art.getClassifier()))) continue;
            artifact = art;
        }
        if (artifact == null) {
            String msg = String.format("can't find artifact %s::%s::%s-%s", groupId, artifactId, version, classifier);
            this.getLog().error((CharSequence)msg);
            throw new Exception(msg);
        }
        return artifact.getFile();
    }
}

