/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import sbt_inc.SbtIncrementalCompiler;
import scala_maven.FileUtils;
import scala_maven.ScalaSourceMojoSupport;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.MainHelper;
import xsbti.CompileFailed;

public abstract class ScalaCompilerSupport
extends ScalaSourceMojoSupport {
    public static final String ALL = "all";
    public static final String MODIFIED_ONLY = "modified-only";
    public static final String INCREMENTAL = "incremental";
    private boolean compileErrors;
    protected long loopSleep = 2500L;
    protected String recompileMode = "all";
    private boolean notifyCompilation = true;
    private long _lastCompileAt = -1L;
    private SbtIncrementalCompiler incremental;
    private String compileOrder;
    private boolean useZincServer;
    private int zincPort;

    protected abstract File getOutputDir() throws Exception;

    protected abstract List<String> getClasspathElements() throws Exception;

    protected abstract File getAnalysisCacheFile() throws Exception;

    @Override
    protected void doExecute() throws Exception {
        if (this.getLog().isDebugEnabled()) {
            for (File directory : this.getSourceDirectories()) {
                this.getLog().debug((CharSequence)FileUtils.pathOf(directory, this.useCanonicalPath));
            }
        }
        File outputDir = FileUtils.fileOf(this.getOutputDir(), this.useCanonicalPath);
        File analysisCacheFile = FileUtils.fileOf(this.getAnalysisCacheFile(), this.useCanonicalPath);
        int nbFiles = this.compile(this.getSourceDirectories(), outputDir, analysisCacheFile, this.getClasspathElements(), false);
        switch (nbFiles) {
            case -1: {
                this.getLog().warn((CharSequence)"No source files found.");
                break;
            }
            case 0: {
                this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
                break;
            }
        }
    }

    protected int compile(List<File> sourceRootDirs, File outputDir, File analysisCacheFile, List<String> classpathElements, boolean compileInLoop) throws Exception, InterruptedException {
        List<File> files;
        if (INCREMENTAL.equals(this.recompileMode)) {
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            return this.incrementalCompile(classpathElements, sourceRootDirs, outputDir, analysisCacheFile, compileInLoop);
        }
        long t0 = System.currentTimeMillis();
        LastCompilationInfo lastCompilationInfo = LastCompilationInfo.find(sourceRootDirs, outputDir);
        if (this._lastCompileAt < 0L) {
            this._lastCompileAt = lastCompilationInfo.getLastSuccessfullTS();
        }
        if ((files = this.getFilesToCompile(sourceRootDirs, this._lastCompileAt)) == null) {
            return -1;
        }
        if (files.size() < 1) {
            return 0;
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        long t1 = System.currentTimeMillis();
        this.getLog().info((CharSequence)String.format("Compiling %d source files to %s at %d", files.size(), outputDir.getAbsolutePath(), t1));
        JavaMainCaller jcmd = this.getScalaCommand();
        jcmd.redirectToLog();
        jcmd.addArgs("-classpath", MainHelper.toMultiPath(classpathElements));
        jcmd.addArgs("-d", outputDir.getAbsolutePath());
        for (File f : files) {
            jcmd.addArgs(f.getAbsolutePath());
        }
        if (jcmd.run(this.displayCmd, !compileInLoop)) {
            lastCompilationInfo.setLastSuccessfullTS(t1);
        } else {
            this.compileErrors = true;
        }
        this.getLog().info((CharSequence)String.format("prepare-compile in %d s", (t1 - t0) / 1000L));
        this.getLog().info((CharSequence)String.format("compile in %d s", (System.currentTimeMillis() - t1) / 1000L));
        this._lastCompileAt = t1;
        return files.size();
    }

    protected boolean hasCompileErrors() {
        return this.compileErrors;
    }

    protected void clearCompileErrors() {
        this.compileErrors = false;
    }

    protected List<File> getFilesToCompile(List<File> sourceRootDirs, long lastSuccessfullCompileTime) throws Exception {
        List<File> sourceFiles = this.findSourceWithFilters(sourceRootDirs);
        if (sourceFiles.size() == 0) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(sourceFiles.size());
        if (this._lastCompileAt > 0L || !ALL.equals(this.recompileMode) && lastSuccessfullCompileTime > 0L) {
            ArrayList<File> modifiedScalaFiles = new ArrayList<File>(sourceFiles.size());
            ArrayList<File> modifiedJavaFiles = new ArrayList<File>(sourceFiles.size());
            ArrayList<File> allJavaFiles = new ArrayList<File>(sourceFiles.size());
            for (File f : sourceFiles) {
                if (f.getName().endsWith(".java")) {
                    allJavaFiles.add(f);
                }
                if (f.lastModified() < lastSuccessfullCompileTime) continue;
                if (f.getName().endsWith(".java")) {
                    modifiedJavaFiles.add(f);
                    continue;
                }
                modifiedScalaFiles.add(f);
            }
            if (modifiedScalaFiles.size() != 0 || modifiedJavaFiles.size() != 0) {
                if (modifiedScalaFiles.size() != 0 && MODIFIED_ONLY.equals(this.recompileMode)) {
                    files.addAll(allJavaFiles);
                    files.addAll(modifiedScalaFiles);
                    this.notifyCompilation(files);
                } else {
                    files.addAll(sourceFiles);
                    this.notifyCompilation(sourceRootDirs);
                }
            }
        } else {
            files.addAll(sourceFiles);
            this.notifyCompilation(sourceRootDirs);
        }
        return files;
    }

    private void notifyCompilation(List<File> files) throws Exception {
        if (this.notifyCompilation) {
            for (File f : files) {
                this.getLog().info((CharSequence)String.format("%s:-1: info: compiling", FileUtils.pathOf(f, this.useCanonicalPath)));
            }
        }
    }

    protected int incrementalCompile(List<String> classpathElements, List<File> sourceRootDirs, File outputDir, File cacheFile, boolean compileInLoop) throws Exception, InterruptedException {
        List<File> sources = this.findSourceWithFilters(sourceRootDirs);
        if (sources.isEmpty()) {
            return -1;
        }
        if (this.incremental == null) {
            File libraryJar = this.getLibraryJar();
            File compilerJar = this.getCompilerJar();
            List<File> extraJars = this.getCompilerDependencies();
            extraJars.remove(libraryJar);
            String sbtGroupId = "com.typesafe.sbt";
            String xsbtiArtifactId = "sbt-interface";
            String compilerInterfaceArtifactId = "compiler-interface";
            String compilerInterfaceClassifier = "sources";
            String sbtVersion = this.findVersionFromPluginArtifacts(sbtGroupId, "incremental-compiler");
            File xsbtiJar = this.getPluginArtifactJar(sbtGroupId, xsbtiArtifactId, sbtVersion);
            File interfaceSrcJar = this.getPluginArtifactJar(sbtGroupId, compilerInterfaceArtifactId, sbtVersion, compilerInterfaceClassifier);
            this.incremental = new SbtIncrementalCompiler(this.useZincServer, this.zincPort, libraryJar, compilerJar, extraJars, xsbtiJar, interfaceSrcJar, this.getLog());
        }
        classpathElements.remove(outputDir.getAbsolutePath());
        List<String> scalacOptions = this.getScalaOptions();
        List<String> javacOptions = this.getJavacOptions();
        Map<File, File> cacheMap = this.getAnalysisCacheMap();
        try {
            this.incremental.compile(this.project.getBasedir(), classpathElements, sources, outputDir, scalacOptions, javacOptions, cacheFile, cacheMap, this.compileOrder);
        }
        catch (CompileFailed e) {
            if (compileInLoop) {
                this.compileErrors = true;
            }
            throw e;
        }
        return 1;
    }

    protected Map<File, File> getAnalysisCacheMap() {
        HashMap<File, File> map = new HashMap<File, File>();
        String scalaPluginKey = ((PluginDescriptor)this.getPluginContext().get("pluginDescriptor")).getPluginLookupKey();
        for (MavenProject project1 : this.reactorProjects) {
            Plugin plugin = project1.getPlugin(scalaPluginKey);
            if (plugin == null) continue;
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            Xpp3Dom analysisCache = configuration != null ? configuration.getChild("analysisCacheFile") : null;
            File analysisCacheFile = analysisCache != null ? new File(analysisCache.getValue()) : this.defaultAnalysisCacheFile(project1);
            File classesDirectory = new File(project1.getBuild().getOutputDirectory());
            map.put(classesDirectory.getAbsoluteFile(), analysisCacheFile.getAbsoluteFile());
            Xpp3Dom testAnalysisCache = configuration != null ? configuration.getChild("testAnalysisCacheFile") : null;
            File testAnalysisCacheFile = testAnalysisCache != null ? new File(testAnalysisCache.getValue()) : this.defaultTestAnalysisCacheFile(project1);
            File testClassesDirectory = new File(project1.getBuild().getTestOutputDirectory());
            map.put(testClassesDirectory.getAbsoluteFile(), testAnalysisCacheFile.getAbsoluteFile());
        }
        return map;
    }

    protected File defaultAnalysisDirectory(MavenProject p) {
        return new File(p.getBuild().getDirectory(), "analysis");
    }

    protected File defaultAnalysisCacheFile(MavenProject p) {
        return new File(this.defaultAnalysisDirectory(p), "compile");
    }

    protected File defaultTestAnalysisCacheFile(MavenProject p) {
        return new File(this.defaultAnalysisDirectory(p), "test-compile");
    }

    private static class LastCompilationInfo {
        private final File _lastCompileAtFile;
        private final File _outputDir;

        static LastCompilationInfo find(List<File> sourceRootDirs, File outputDir) throws Exception {
            StringBuilder hash = new StringBuilder();
            for (File f : sourceRootDirs) {
                hash.append(f.toString());
            }
            return new LastCompilationInfo(new File(outputDir.getAbsolutePath() + "." + hash.toString().hashCode() + ".timestamp"), outputDir);
        }

        private LastCompilationInfo(File f, File outputDir) {
            this._lastCompileAtFile = f;
            this._outputDir = outputDir;
        }

        long getLastSuccessfullTS() throws Exception {
            long back = -1L;
            if (this._lastCompileAtFile.exists() && this._outputDir.exists() && this._outputDir.list().length > 0) {
                back = this._lastCompileAtFile.lastModified();
            }
            return back;
        }

        void setLastSuccessfullTS(long v) throws Exception {
            if (!this._lastCompileAtFile.exists()) {
                FileUtils.fileWrite((String)this._lastCompileAtFile.getAbsolutePath(), (String)".");
            }
            this._lastCompileAtFile.setLastModified(v);
        }
    }
}

