/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import org.apache.maven.toolchain.Toolchain;

public class JavaLocator {
    public static String findExecutableFromToolchain(Toolchain toolchain) {
        String _javaExec = null;
        if (toolchain != null) {
            _javaExec = toolchain.findTool("java");
        }
        if (toolchain == null || _javaExec == null) {
            _javaExec = System.getenv("JAVA_HOME");
            if (_javaExec == null && (_javaExec = System.getProperty("java.home")) == null) {
                throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
            }
            _javaExec = _javaExec + File.separator + "bin" + File.separator + "java";
        }
        return _javaExec;
    }

    static String findHomeFromToolchain(Toolchain toolchain) {
        String executable = JavaLocator.findExecutableFromToolchain(toolchain);
        File executableParent = new File(executable).getParentFile();
        if (executableParent == null) {
            return null;
        }
        return executableParent.getParent();
    }
}

