/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_dependency;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import scala_maven.VersionNumber;
import scala_maven_dependency.ScalaConstants;
import scala_maven_dependency.StringUtil;

public class CheckScalaVersionVisitor
implements DependencyNodeVisitor {
    private VersionNumber _version;
    private boolean _failed = false;
    private Log _log;
    private String _scalaOrganization;
    private List<String> scalaDependentArtifactStrings = new ArrayList<String>();

    public boolean endVisit(DependencyNode node) {
        return !this._failed;
    }

    public CheckScalaVersionVisitor(VersionNumber version, Log log, String scalaOrganization) {
        this._version = version;
        this._log = log;
        this._scalaOrganization = scalaOrganization;
    }

    private boolean isScalaDistroArtifact(Artifact artifact) {
        return this._scalaOrganization.equalsIgnoreCase(artifact.getGroupId()) && ScalaConstants.SCALA_DISTRO_ARTIFACTS.contains(artifact.getArtifactId());
    }

    public boolean visit(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        this._log.debug((CharSequence)("checking [" + artifact + "] for scala version"));
        if (this.isScalaDistroArtifact(artifact) && artifact.getVersion() != null) {
            VersionNumber originalVersion = new VersionNumber(artifact.getVersion());
            if (this._version.compareTo(originalVersion) != 0) {
                this._failed = true;
            }
            if (node.getParent() != null) {
                Artifact parentArtifact = node.getParent().getArtifact();
                this.scalaDependentArtifactStrings.add(" " + StringUtil.makeArtifactNameString(parentArtifact) + " requires scala version: " + originalVersion);
            }
        }
        return !this._failed;
    }

    public boolean isFailed() {
        return this._failed;
    }

    public void logScalaDependents() {
        this._log.warn((CharSequence)(" Expected all dependencies to require Scala version: " + this._version));
        for (String dependString : this.scalaDependentArtifactStrings) {
            this._log.warn((CharSequence)dependString);
        }
    }
}

