/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.FileAnalysisStore;
import sbt.internal.inc.Locate;
import sbt.internal.inc.LoggedReporter;
import sbt.internal.inc.PlainVirtualFile;
import sbt.internal.inc.PlainVirtualFileConverter;
import sbt.internal.inc.RawCompiler;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.ZincUtil;
import sbt.internal.inc.classpath.ClasspathUtil;
import sbt.io.AllPassFilter$;
import sbt.io.IO;
import sbt.io.NameFilter;
import sbt.util.Logger;
import sbt_inc.SbtLogger;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters;
import scala.jdk.FunctionWrappers;
import scala_maven.MavenArtifactResolver;
import scala_maven.VersionNumber;
import util.FileUtils;
import xsbti.PathBasedFile;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.VirtualFile;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOptions;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileResult;
import xsbti.compile.CompilerCache;
import xsbti.compile.Compilers;
import xsbti.compile.DefinesClass;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.IncrementalCompiler;
import xsbti.compile.Inputs;
import xsbti.compile.MiniSetup;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.PreviousResult;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.Setup;
import xsbti.compile.ZincCompilerUtil;

public class SbtIncrementalCompiler {
    private static final String SBT_GROUP_ID = "org.scala-sbt";
    private static final String JAVA_CLASS_VERSION = System.getProperty("java.class.version");
    private static final File DEFAULT_SECONDARY_CACHE_DIR = Paths.get(System.getProperty("user.home"), ".sbt", "1.0", "zinc", "org.scala-sbt").toFile();
    private final IncrementalCompiler compiler = ZincUtil.defaultIncrementalCompiler();
    private final CompileOrder compileOrder;
    private final Logger logger;
    private final Compilers compilers;
    private final Setup setup;
    private final AnalysisStore analysisStore;
    private final MavenArtifactResolver resolver;
    private final File secondaryCacheDir;

    public SbtIncrementalCompiler(File libraryJar, File reflectJar, File compilerJar, VersionNumber scalaVersion, List<File> extraJars, Path javaHome, MavenArtifactResolver resolver, File secondaryCacheDir, Log mavenLogger, File cacheFile, CompileOrder compileOrder) throws Exception {
        this.compileOrder = compileOrder;
        this.logger = new SbtLogger(mavenLogger);
        mavenLogger.info((CharSequence)("Using incremental compilation using " + compileOrder + " compile order"));
        this.resolver = resolver;
        this.secondaryCacheDir = secondaryCacheDir != null ? secondaryCacheDir : DEFAULT_SECONDARY_CACHE_DIR;
        this.secondaryCacheDir.mkdirs();
        ArrayList<File> allJars = new ArrayList<File>(extraJars);
        allJars.add(libraryJar);
        allJars.add(reflectJar);
        allJars.add(compilerJar);
        ScalaInstance scalaInstance = new ScalaInstance(scalaVersion.toString(), (ClassLoader)new URLClassLoader(new URL[]{libraryJar.toURI().toURL(), reflectJar.toURI().toURL(), compilerJar.toURI().toURL()}), ClasspathUtil.rootLoader(), libraryJar, compilerJar, allJars.toArray(new File[0]), Option.apply((Object)scalaVersion.toString()));
        File compilerBridgeJar = this.getCompiledBridgeJar(scalaInstance, mavenLogger);
        AnalyzingCompiler scalaCompiler = new AnalyzingCompiler((xsbti.compile.ScalaInstance)scalaInstance, ZincCompilerUtil.constantBridgeProvider((xsbti.compile.ScalaInstance)scalaInstance, (File)compilerBridgeJar), ClasspathOptionsUtil.auto(), (Function1)new FunctionWrappers.FromJavaConsumer(noop -> {}), Option.apply(null));
        this.compilers = ZincUtil.compilers((xsbti.compile.ScalaInstance)scalaInstance, (ClasspathOptions)ClasspathOptionsUtil.boot(), (Option)Option.apply((Object)javaHome), (ScalaCompiler)scalaCompiler);
        PerClasspathEntryLookup lookup = new PerClasspathEntryLookup(){

            public Optional<CompileAnalysis> analysis(VirtualFile classpathEntry) {
                File analysisStoreFile;
                Path path = ((PathBasedFile)classpathEntry).toPath();
                String analysisStoreFileName = null;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (path.getFileName().equals("classes")) {
                        analysisStoreFileName = "compile";
                    } else if (path.getFileName().equals("test-classes")) {
                        analysisStoreFileName = "test-compile";
                    }
                }
                if (analysisStoreFileName != null && (analysisStoreFile = path.getParent().resolve("analysis").resolve(analysisStoreFileName).toFile()).exists()) {
                    return AnalysisStore.getCachedStore((AnalysisStore)FileAnalysisStore.binary((File)analysisStoreFile)).get().map(AnalysisContents::getAnalysis);
                }
                return Optional.empty();
            }

            public DefinesClass definesClass(VirtualFile classpathEntry) {
                return Locate.definesClass((VirtualFile)classpathEntry);
            }
        };
        this.analysisStore = AnalysisStore.getCachedStore((AnalysisStore)FileAnalysisStore.binary((File)cacheFile));
        this.setup = Setup.of((PerClasspathEntryLookup)lookup, (boolean)false, (File)cacheFile, (GlobalsCache)CompilerCache.fresh(), (IncOptions)IncOptions.of(), (Reporter)new LoggedReporter(100, (xsbti.Logger)this.logger, pos -> pos), Optional.empty(), (T2[])new T2[0]);
    }

    private PreviousResult previousResult() {
        Optional analysisContents = this.analysisStore.get();
        if (analysisContents.isPresent()) {
            AnalysisContents analysisContents0 = (AnalysisContents)analysisContents.get();
            CompileAnalysis previousAnalysis = analysisContents0.getAnalysis();
            MiniSetup previousSetup = analysisContents0.getMiniSetup();
            return PreviousResult.of(Optional.of(previousAnalysis), Optional.of(previousSetup));
        }
        return PreviousResult.of(Optional.empty(), Optional.empty());
    }

    public void compile(Set<String> classpathElements, List<Path> sources, Path classesDirectory, List<String> scalacOptions, List<String> javacOptions) {
        ArrayList<Path> fullClasspath = new ArrayList<Path>();
        fullClasspath.add(classesDirectory);
        for (String classpathElement : classpathElements) {
            fullClasspath.add(Paths.get(classpathElement, new String[0]));
        }
        CompileOptions options = CompileOptions.of((VirtualFile[])((VirtualFile[])fullClasspath.stream().map(PlainVirtualFile::new).toArray(VirtualFile[]::new)), (VirtualFile[])((VirtualFile[])sources.stream().map(PlainVirtualFile::new).toArray(VirtualFile[]::new)), (Path)classesDirectory, (String[])scalacOptions.toArray(new String[0]), (String[])javacOptions.toArray(new String[0]), (int)100, pos -> pos, (CompileOrder)this.compileOrder, Optional.empty(), Optional.of(PlainVirtualFileConverter.converter()), Optional.empty(), Optional.empty());
        Inputs inputs = Inputs.of((Compilers)this.compilers, (CompileOptions)options, (Setup)this.setup, (PreviousResult)this.previousResult());
        CompileResult newResult = this.compiler.compile(inputs, (xsbti.Logger)this.logger);
        this.analysisStore.set(AnalysisContents.create((CompileAnalysis)newResult.analysis(), (MiniSetup)newResult.setup()));
    }

    private String compilerBridgeArtifactId(String scalaVersion) {
        if (scalaVersion.startsWith("2.10.")) {
            return "compiler-bridge_2.10";
        }
        if (scalaVersion.startsWith("2.11.")) {
            return "compiler-bridge_2.11";
        }
        if (scalaVersion.startsWith("2.12.") || scalaVersion.equals("2.13.0-M1")) {
            return "compiler-bridge_2.12";
        }
        return "compiler-bridge_2.13";
    }

    private static List<Tuple2<File, String>> computeZipEntries(List<Path> paths, Path rootDir) {
        int rootDirLength = rootDir.toString().length();
        Stream<Tuple2> stream = paths.stream().map(path -> {
            String zipPath = path.toString().substring(rootDirLength + 1).replace(File.separator, "/");
            if (Files.isDirectory(path, new LinkOption[0])) {
                zipPath = zipPath + "/";
            }
            return new Tuple2((Object)path.toFile(), (Object)zipPath);
        });
        return stream.collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getCompiledBridgeJar(ScalaInstance scalaInstance, Log mavenLogger) throws Exception {
        String bridgeArtifactId = this.compilerBridgeArtifactId(scalaInstance.actualVersion());
        Properties properties = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("incrementalcompiler.version.properties");){
            properties.load(is);
        }
        String zincVersion = properties.getProperty("version");
        String timestamp = properties.getProperty("timestamp");
        String cacheFileName = "org.scala-sbt-" + bridgeArtifactId + '-' + zincVersion + "-bin_" + scalaInstance.actualVersion() + "__" + JAVA_CLASS_VERSION + '-' + zincVersion + '_' + timestamp + ".jar";
        File cachedCompiledBridgeJar = new File(this.secondaryCacheDir, cacheFileName);
        if (mavenLogger.isInfoEnabled()) {
            mavenLogger.info((CharSequence)("Compiler bridge file: " + cachedCompiledBridgeJar));
        }
        if (!cachedCompiledBridgeJar.exists()) {
            mavenLogger.info((CharSequence)"Compiler bridge file is not installed yet");
            RawCompiler rawCompiler = new RawCompiler((xsbti.compile.ScalaInstance)scalaInstance, ClasspathOptionsUtil.auto(), this.logger);
            File bridgeSources = this.resolver.getJar(SBT_GROUP_ID, bridgeArtifactId, zincVersion, "sources").getFile();
            Set bridgeSourcesDependencies = this.resolver.getJarAndDependencies(SBT_GROUP_ID, bridgeArtifactId, zincVersion, "sources").stream().filter(artifact -> artifact.getScope() != null && !artifact.getScope().equals("provided")).map(Artifact::getFile).map(File::toPath).collect(Collectors.toSet());
            bridgeSourcesDependencies.addAll(((Stream)Arrays.stream(scalaInstance.allJars()).sequential()).map(File::toPath).collect(Collectors.toList()));
            Path sourcesDir = Files.createTempDirectory("scala-maven-plugin-compiler-bridge-sources", new FileAttribute[0]);
            Path classesDir = Files.createTempDirectory("scala-maven-plugin-compiler-bridge-classes", new FileAttribute[0]);
            IO.unzip((File)bridgeSources, (File)sourcesDir.toFile(), (NameFilter)AllPassFilter$.MODULE$, (boolean)true);
            List<Path> bridgeSourcesScalaFiles = FileUtils.listDirectoryContent(sourcesDir, file -> Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".scala"));
            List<Path> bridgeSourcesNonScalaFiles = FileUtils.listDirectoryContent(sourcesDir, file -> Files.isRegularFile(file, new LinkOption[0]) && !file.getFileName().toString().endsWith(".scala") && !file.getFileName().toString().equals("MANIFEST.MF"));
            try {
                rawCompiler.apply(CollectionConverters.IterableHasAsScala(bridgeSourcesScalaFiles).asScala().toSeq(), CollectionConverters.IterableHasAsScala(bridgeSourcesDependencies).asScala().toSeq(), classesDir, CollectionConverters.IterableHasAsScala(Collections.emptyList()).asScala().toSeq());
                Manifest manifest = new Manifest();
                Path sourcesManifestFile = sourcesDir.resolve("META-INF").resolve("MANIFEST.MF");
                try (FileInputStream is = new FileInputStream(sourcesManifestFile.toFile());){
                    manifest.read(is);
                }
                List<Tuple2<File, String>> scalaCompiledClasses = SbtIncrementalCompiler.computeZipEntries(FileUtils.listDirectoryContent(classesDir, file -> true), classesDir);
                List<Tuple2<File, String>> resources = SbtIncrementalCompiler.computeZipEntries(bridgeSourcesNonScalaFiles, sourcesDir);
                ArrayList<Tuple2<File, String>> allZipEntries = new ArrayList<Tuple2<File, String>>();
                allZipEntries.addAll(scalaCompiledClasses);
                allZipEntries.addAll(resources);
                IO.jar((Iterable)CollectionConverters.IterableHasAsScala(allZipEntries).asScala(), (File)cachedCompiledBridgeJar, (Manifest)manifest);
                mavenLogger.info((CharSequence)"Compiler bridge installed");
            }
            finally {
                FileUtils.deleteDirectory(sourcesDir);
                FileUtils.deleteDirectory(classesDir);
            }
        }
        return cachedCompiledBridgeJar;
    }
}

