/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.BasicArtifact;
import scala_maven.ScalaSourceMojoSupport;
import scala_maven.VersionNumber;
import scala_maven_executions.JavaMainCaller;
import util.FileUtils;

@Mojo(name="doc", requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class ScalaDocMojo
extends ScalaSourceMojoSupport
implements MavenReport {
    @Parameter(property="windowtitle", defaultValue="${project.name} ${project.version} API")
    private String windowtitle;
    @Parameter(property="bottom", defaultValue="Copyright (c) {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.")
    private String bottom;
    @Parameter(property="charset", defaultValue="ISO-8859-1")
    private String charset;
    @Parameter(property="doctitle", defaultValue="${project.name} ${project.version} API")
    private String doctitle;
    @Parameter(property="footer")
    private String footer;
    @Parameter(property="header")
    private String header;
    @Parameter(property="linksource", defaultValue="true")
    private boolean linksource;
    @Parameter(property="nocomment", defaultValue="false")
    private boolean nocomment;
    @Parameter(property="stylesheetfile")
    private File stylesheetfile;
    @Parameter(property="top")
    private String top;
    @Parameter(defaultValue="scaladocs", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/scaladocs", required=true)
    File reportOutputDirectory;
    @Parameter(property="name", defaultValue="ScalaDocs")
    private String name;
    @Parameter(property="description", defaultValue="ScalaDoc API documentation.")
    private String description;
    @Parameter(property="maven.scaladoc.className")
    private String scaladocClassName;
    @Parameter(property="maven.scaladoc.vscaladocVersion")
    private String vscaladocVersion;
    @Parameter(property="forceAggregate", defaultValue="false")
    private boolean forceAggregate;
    @Parameter(property="maven.scaladoc.aggregateDirectOnly", defaultValue="true")
    private boolean aggregateDirectOnly;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala")
    private File sourceDir;
    private List<File> _sourceFiles;

    @Override
    protected List<File> getSourceDirectories() throws Exception {
        String scalaSourceDir;
        List sources = this.project.getCompileSourceRoots();
        if (!sources.contains(scalaSourceDir = FileUtils.pathOf(this.sourceDir, this.useCanonicalPath))) {
            sources.add(scalaSourceDir);
        }
        return this.normalize(sources);
    }

    public boolean canGenerateReport() {
        boolean back = (this.project.isExecutionRoot() || this.forceAggregate) && this.canAggregate() && this.project.getCollectedProjects().size() > 0;
        back = back || this.findSourceFiles().size() != 0;
        return back;
    }

    private List<File> findSourceFiles() {
        if (this._sourceFiles == null) {
            try {
                this._sourceFiles = this.findSourceWithFilters();
            }
            catch (Exception exc) {
                throw new RuntimeException("can't define source to process", exc);
            }
        }
        return this._sourceFiles;
    }

    private boolean canAggregate() {
        return StringUtils.isNotEmpty((String)this.vscaladocVersion) && new VersionNumber(this.vscaladocVersion).compareTo(new VersionNumber("1.1")) >= 0;
    }

    public boolean isExternalReport() {
        return true;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return "ScalaDoc API documentation";
        }
        return this.description;
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return "ScalaDocs";
        }
        return this.name;
    }

    public String getOutputName() {
        return this.outputDirectory + "/index";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.project.getBasedir(), this.project.getModel().getReporting().getOutputDirectory() + "/" + this.outputDirectory).getAbsoluteFile();
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File v) {
        this.reportOutputDirectory = v != null && this.outputDirectory != null && !v.getAbsolutePath().endsWith(this.outputDirectory) ? new File(v, this.outputDirectory) : v;
    }

    @Override
    public void doExecute() throws Exception {
        this.generate(null, Locale.getDefault());
    }

    @Override
    protected JavaMainCaller getScalaCommand() throws Exception {
        boolean isScaladoc2;
        boolean isPreviousScala271;
        this.checkScalaVersion();
        VersionNumber sv = this.findScalaContext().version();
        boolean bl = isPreviousScala271 = new VersionNumber("2.7.1").compareTo(sv) > 0 && !sv.isZero();
        if (StringUtils.isEmpty((String)this.scaladocClassName)) {
            this.scaladocClassName = !isPreviousScala271 ? "scala.tools.nsc.ScalaDoc" : this.scalaClassName;
        }
        JavaMainCaller jcmd = this.getEmptyScalaCommand(this.scaladocClassName);
        jcmd.addArgs(this.args);
        jcmd.addJvmArgs(this.jvmArgs);
        this.addCompilerPluginOptions(jcmd);
        if (isPreviousScala271) {
            jcmd.addArgs("-Ydoc");
        }
        HashSet<File> paths = new HashSet<File>();
        for (String s : this.project.getCompileClasspathElements()) {
            paths.add(new File(s));
        }
        paths.remove(this.project.getBuild().getOutputDirectory());
        this.addAdditionalDependencies(paths);
        if (!paths.isEmpty()) {
            jcmd.addOption("-classpath", FileUtils.toMultiPath(paths));
        }
        boolean bl2 = isScaladoc2 = (new VersionNumber("2.8.0").compareTo(sv) <= 0 || sv.isZero()) && "scala.tools.nsc.ScalaDoc".equals(this.scaladocClassName);
        if (isScaladoc2) {
            jcmd.addArgs("-doc-format:html");
            jcmd.addOption("-doc-title", this.doctitle);
        } else {
            jcmd.addOption("-bottom", this.getBottomText());
            jcmd.addOption("-charset", this.charset);
            jcmd.addOption("-doctitle", this.doctitle);
            jcmd.addOption("-footer", this.footer);
            jcmd.addOption("-header", this.header);
            jcmd.addOption("-linksource", this.linksource);
            jcmd.addOption("-nocomment", this.nocomment);
            jcmd.addOption("-stylesheetfile", this.stylesheetfile);
            jcmd.addOption("-top", this.top);
            jcmd.addOption("-windowtitle", this.windowtitle);
        }
        return jcmd;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            List<File> sources;
            if (!this.canGenerateReport()) {
                this.getLog().info((CharSequence)"No source files found");
                return;
            }
            File reportOutputDir = this.getReportOutputDirectory();
            if (!reportOutputDir.exists()) {
                reportOutputDir.mkdirs();
            }
            if (StringUtils.isNotEmpty((String)this.vscaladocVersion)) {
                this.scaladocClassName = "org.scala_tools.vscaladoc.Main";
                BasicArtifact artifact = new BasicArtifact();
                artifact.artifactId = "vscaladoc";
                artifact.groupId = "org.scala-tools";
                artifact.version = this.vscaladocVersion;
                this.dependencies = new BasicArtifact[]{artifact};
            }
            if ((sources = this.findSourceFiles()).size() > 0) {
                JavaMainCaller jcmd = this.getScalaCommand();
                jcmd.addOption("-d", reportOutputDir.getAbsolutePath());
                for (File x : sources) {
                    jcmd.addArgs(FileUtils.pathOf(x, this.useCanonicalPath));
                }
                jcmd.run(this.displayCmd);
            }
            if (this.forceAggregate) {
                this.aggregate(this.project);
            } else {
                this.tryAggregateUpper(this.project);
            }
        }
        catch (RuntimeException | MavenReportException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MavenReportException("wrap: " + exc.getMessage(), exc);
        }
    }

    private void tryAggregateUpper(MavenProject prj) throws Exception {
        MavenProject parent;
        List modules;
        if (prj != null && prj.hasParent() && this.canAggregate() && (modules = (parent = prj.getParent()).getCollectedProjects()).size() > 1 && prj.equals(modules.get(modules.size() - 1))) {
            this.aggregate(parent);
        }
    }

    private void aggregate(MavenProject parent) throws Exception {
        List modules = parent.getCollectedProjects();
        File dest = new File(parent.getModel().getReporting().getOutputDirectory() + "/" + this.outputDirectory);
        this.getLog().info((CharSequence)("start aggregation into " + dest));
        StringBuilder mpath = new StringBuilder();
        for (MavenProject module : modules) {
            File subScaladocPath;
            if ("pom".equals(module.getPackaging().toLowerCase()) || this.aggregateDirectOnly && module.getParent() != parent || !(subScaladocPath = new File(module.getModel().getReporting().getOutputDirectory() + "/" + this.outputDirectory).getAbsoluteFile()).exists()) continue;
            mpath.append(subScaladocPath).append(File.pathSeparatorChar);
        }
        if (mpath.length() != 0) {
            this.getLog().info((CharSequence)("aggregate vscaladoc from : " + mpath));
            JavaMainCaller jcmd = this.getScalaCommand();
            jcmd.addOption("-d", dest.getAbsolutePath());
            jcmd.addOption("-aggregate", mpath.toString());
            jcmd.run(this.displayCmd);
        } else {
            this.getLog().warn((CharSequence)"no vscaladoc to aggregate");
        }
        this.tryAggregateUpper(parent);
    }

    private String getBottomText() {
        String inceptionYear = this.project.getInceptionYear();
        int actualYear = Calendar.getInstance().get(1);
        String year = String.valueOf(actualYear);
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (this.project.getOrganization() != null && StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }
}

