/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import util.FileUtils;

@Mojo(name="add-source", executionStrategy="always", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class AddSourceMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala")
    private File sourceDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../scala")
    private File testSourceDir;
    @Parameter(property="maven.scala.useCanonicalPath", defaultValue="true")
    private boolean useCanonicalPath;

    public void execute() {
        try {
            String path;
            if (this.sourceDir != null) {
                path = FileUtils.pathOf(this.sourceDir, this.useCanonicalPath);
                if (!this.project.getCompileSourceRoots().contains(path)) {
                    this.getLog().info((CharSequence)("Add Source directory: " + path));
                    this.project.addCompileSourceRoot(path);
                }
            }
            if (this.testSourceDir != null) {
                path = FileUtils.pathOf(this.testSourceDir, this.useCanonicalPath);
                if (!this.project.getTestCompileSourceRoots().contains(path)) {
                    this.getLog().info((CharSequence)("Add Test Source directory: " + path));
                    this.project.addTestCompileSourceRoot(path);
                }
            }
        }
        catch (Exception exc) {
            this.getLog().warn((Throwable)exc);
        }
    }
}

