/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import org.apache.maven.plugin.logging.Log;
import sbt.util.Level;
import sbt.util.Logger;
import scala.Enumeration;
import scala.Function0;

public class SbtLogger
extends Logger {
    private final Log log;

    SbtLogger(Log l) {
        this.log = l;
    }

    public void trace(Function0<Throwable> t) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Throwable)t.apply());
        }
    }

    public void success(Function0<String> message) {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Success: " + (String)message.apply()));
        }
    }

    public void log(Enumeration.Value level, Function0<String> message) {
        String prefix;
        String s = (String)message.apply();
        if (s.regionMatches(true, 0, prefix = "[" + level.toString() + "] ", 0, prefix.length())) {
            s = s.substring(prefix.length());
        }
        if (level.equals((Object)Level.Error())) {
            this.log.error((CharSequence)s);
        } else if (level.equals((Object)Level.Warn())) {
            this.log.warn((CharSequence)s);
        } else if (level.equals((Object)Level.Info())) {
            this.log.info((CharSequence)s);
        } else if (level.equals((Object)Level.Debug())) {
            this.log.debug((CharSequence)s);
        }
    }
}

