/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.toolchain.Toolchain;

public class JavaLocator {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win");

    public static String findExecutableFromToolchain(Toolchain toolchain) throws IOException {
        String fromToolChain;
        if (toolchain != null && (fromToolChain = toolchain.findTool("java")) != null) {
            return fromToolChain;
        }
        String javaCommand = "java" + (IS_WINDOWS ? ".exe" : "");
        String javaHomeSystemProperty = System.getProperty("java.home");
        if (javaHomeSystemProperty != null) {
            File javaExecFile;
            if (javaHomeSystemProperty.endsWith(File.separator + "jre") && (javaExecFile = new File(javaHomeSystemProperty + File.separator + ".." + File.separator + "bin", javaCommand)).isFile()) {
                return javaExecFile.getCanonicalPath();
            }
            javaExecFile = new File(javaHomeSystemProperty + File.separator + "bin", javaCommand);
            if (javaExecFile.isFile()) {
                return javaExecFile.getAbsolutePath();
            }
            throw new IllegalStateException("Couldn't locate java in defined java.home system property.");
        }
        String javaHomeEnvVar = System.getenv("JAVA_HOME");
        if (javaHomeEnvVar == null) {
            throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
        }
        File javaExecFile = new File(javaHomeEnvVar + File.separator + "bin", javaCommand);
        if (javaExecFile.isFile()) {
            return javaExecFile.getAbsolutePath();
        }
        throw new IllegalStateException("Couldn't locate java in defined JAVA_HOME environment variable.");
    }

    public static File findHomeFromToolchain(Toolchain toolchain) throws IOException {
        String executable = JavaLocator.findExecutableFromToolchain(toolchain);
        File executableParent = new File(executable).getParentFile();
        if (executableParent == null) {
            return null;
        }
        return executableParent.getParentFile();
    }
}

