/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.Launcher;
import scala_maven.ScalaMojoSupport;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.JavaMainCallerByFork;
import util.FileUtils;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class ScalaRunMojo
extends ScalaMojoSupport {
    @Parameter(property="launcher")
    private String launcher;
    @Parameter(property="addArgs")
    private String addArgs;
    @Parameter
    private Launcher[] launchers;
    @Parameter(property="mainClass")
    private String mainClass;

    @Override
    protected void doExecute() throws Exception {
        JavaMainCaller jcmd = null;
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (StringUtils.isNotEmpty((String)this.mainClass)) {
            jcmd = new JavaMainCallerByFork(this, this.mainClass, FileUtils.toMultiPath(FileUtils.fromStrings(this.project.getTestClasspathElements())), this.jvmArgs, this.args, this.forceUseArgFile, toolchain);
        } else if (this.launchers != null && this.launchers.length > 0) {
            if (StringUtils.isNotEmpty((String)this.launcher)) {
                for (int i = 0; i < this.launchers.length && jcmd == null; ++i) {
                    if (!this.launcher.equals(this.launchers[i].id)) continue;
                    this.getLog().info((CharSequence)("launcher '" + this.launchers[i].id + "' selected => " + this.launchers[i].mainClass));
                    jcmd = new JavaMainCallerByFork(this, this.launchers[i].mainClass, FileUtils.toMultiPath(FileUtils.fromStrings(this.project.getTestClasspathElements())), this.launchers[i].jvmArgs, this.launchers[i].args, this.forceUseArgFile, toolchain);
                }
            } else {
                this.getLog().info((CharSequence)("launcher '" + this.launchers[0].id + "' selected => " + this.launchers[0].mainClass));
                jcmd = new JavaMainCallerByFork(this, this.launchers[0].mainClass, FileUtils.toMultiPath(FileUtils.fromStrings(this.project.getTestClasspathElements())), this.launchers[0].jvmArgs, this.launchers[0].args, this.forceUseArgFile, toolchain);
            }
        }
        if (jcmd != null) {
            if (StringUtils.isNotEmpty((String)this.addArgs)) {
                jcmd.addArgs(StringUtils.split((String)this.addArgs, (String)"|"));
            }
            jcmd.run(this.displayCmd);
        } else {
            this.getLog().warn((CharSequence)"Not mainClass or valid launcher found/define");
        }
    }
}

