/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala_maven.ScalaCompilerSupport;
import util.FileUtils;

@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ScalaTestCompileMojo
extends ScalaCompilerSupport {
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testOutputDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../scala")
    private File testSourceDir;
    @Parameter(property="testAnalysisCacheFile", defaultValue="${project.build.directory}/analysis/test-compile")
    private File testAnalysisCacheFile;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not compiling test sources");
            return;
        }
        super.execute();
    }

    @Override
    protected Set<File> getClasspathElements() throws Exception {
        Set<File> back = FileUtils.fromStrings(this.project.getTestClasspathElements());
        back.remove(new File(this.project.getBuild().getTestOutputDirectory()));
        this.addAdditionalDependencies(back);
        return back;
    }

    @Override
    protected List<Dependency> getDependencies() {
        return this.project.getTestDependencies();
    }

    @Override
    protected File getOutputDir() {
        return this.testOutputDir.getAbsoluteFile();
    }

    @Override
    protected List<File> getSourceDirectories() throws Exception {
        String scalaSourceDir;
        List sources = this.project.getTestCompileSourceRoots();
        if (!sources.contains(scalaSourceDir = this.testSourceDir.getAbsolutePath())) {
            sources.add(scalaSourceDir);
        }
        return this.normalize(sources);
    }

    @Override
    protected File getAnalysisCacheFile() {
        return this.testAnalysisCacheFile.getAbsoluteFile();
    }
}

