/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.maven.toolchain.Toolchain;

public class JavaLocator {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("windows");

    public static String findExecutableFromToolchain(Toolchain toolchain) {
        String fromToolChain;
        if (toolchain != null && (fromToolChain = toolchain.findTool("java")) != null) {
            return fromToolChain;
        }
        String javaCommand = "java" + (IS_WINDOWS ? ".exe" : "");
        String javaHomeSystemProperty = System.getProperty("java.home");
        if (javaHomeSystemProperty != null) {
            Path javaExecPath;
            Path javaHomePath = Paths.get(javaHomeSystemProperty, new String[0]);
            if (javaHomePath.endsWith("jre") && (javaExecPath = javaHomePath.resolveSibling("bin").resolve(javaCommand)).toFile().isFile()) {
                return javaExecPath.toString();
            }
            javaExecPath = javaHomePath.resolve("bin").resolve(javaCommand);
            if (javaExecPath.toFile().isFile()) {
                return javaExecPath.toString();
            }
            throw new IllegalStateException("Couldn't locate java in defined java.home system property.");
        }
        String javaHomeEnvVar = System.getenv("JAVA_HOME");
        if (javaHomeEnvVar == null) {
            throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
        }
        Path javaExecPath = Paths.get(javaHomeEnvVar, new String[0]).resolve("bin").resolve(javaCommand);
        if (javaExecPath.toFile().isFile()) {
            return javaExecPath.toString();
        }
        throw new IllegalStateException("Couldn't locate java in defined JAVA_HOME environment variable.");
    }

    public static File findHomeFromToolchain(Toolchain toolchain) {
        String executable = JavaLocator.findExecutableFromToolchain(toolchain);
        File executableParent = new File(executable).getParentFile();
        if (executableParent == null) {
            return null;
        }
        return executableParent.getParentFile();
    }
}

