/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_executions;

import scala_maven_executions.ForkLogLevel;

public abstract class ForkLogger {
    private final StringBuilder buffer = new StringBuilder();
    private boolean forceFlush;
    private ForkLogLevel currentLogLevel = null;

    public abstract void onException(Exception var1);

    public abstract void onError(String var1);

    public abstract void onWarn(String var1);

    public abstract void onInfo(String var1);

    public abstract void onDebug(String var1);

    private void flushBuffer() {
        if (this.buffer.length() != 0 && this.currentLogLevel != null) {
            switch (this.currentLogLevel) {
                case ERROR: {
                    this.onError(this.buffer.toString());
                    break;
                }
                case WARN: {
                    this.onWarn(this.buffer.toString());
                    break;
                }
                case INFO: {
                    this.onInfo(this.buffer.toString());
                    break;
                }
                case DEBUG: {
                    this.onDebug(this.buffer.toString());
                }
            }
            this.buffer.setLength(0);
        }
    }

    public final void processLine(String line) {
        try {
            ForkLogLevel newLogLevel = ForkLogLevel.level(line);
            if (newLogLevel != null) {
                this.flushBuffer();
                this.currentLogLevel = newLogLevel;
                this.buffer.append(newLogLevel.removeHeader(line));
            } else {
                this.buffer.append(System.lineSeparator()).append(line);
            }
            if (this.forceFlush) {
                this.flushBuffer();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    public final void forceNextLineToFlush() {
        this.forceFlush = true;
    }
}

