/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.xrayinterface;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.amygdalum.xrayinterface.SignatureUtil;
import net.amygdalum.xrayinterface.XRayInterface;

public class Converter {
    private static final int GETTER = 0;
    private static final int SETTER = 1;
    private Map<String, Method[]> properties = new LinkedHashMap<String, Method[]>();

    public void addGetter(Method method) {
        Method[] methods = this.fetchMethods(method);
        methods[0] = method;
    }

    public void addSetter(Method method) {
        Method[] methods = this.fetchMethods(method);
        methods[1] = method;
    }

    private Method[] fetchMethods(Method method) {
        String name = SignatureUtil.propertyOf(method);
        Method[] methods = this.properties.get(name);
        if (methods == null) {
            methods = new Method[2];
            this.properties.put(name, methods);
        }
        return methods;
    }

    public List<Method[]> getReadWritablePropertyPairs() {
        ArrayList<Method[]> propertyPairs = new ArrayList<Method[]>();
        for (Method[] pair : this.properties.values()) {
            if (pair[0] == null || pair[1] == null) continue;
            propertyPairs.add(pair);
        }
        return propertyPairs;
    }

    public static Object[] convertArguments(Class<?>[] targetTypes, Class<?>[] methodTypes, Object ... args) throws InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, SecurityException {
        if (args == null) {
            args = new Object[]{};
        }
        Object[] converted = new Object[args.length];
        Class<?>[] targetArgumentTypes = targetTypes;
        Class<?>[] methodArgumentTypes = methodTypes;
        for (int i = 0; i < args.length; ++i) {
            converted[i] = Converter.convertArgument(targetArgumentTypes[i], methodArgumentTypes[i], args[i]);
        }
        return converted;
    }

    public static Object convertArgument(Class<?> targetType, Class<?> methodType, Object arg) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (targetType.equals(methodType)) {
            return arg;
        }
        if (arg == null) {
            return null;
        }
        return Converter.convert(arg, methodType, targetType);
    }

    public static Object convertResult(Class<?> targetType, Class<?> methodType, Object result) throws NoSuchMethodException {
        if (targetType.isAssignableFrom(methodType)) {
            return result;
        }
        if (result == null) {
            return null;
        }
        return XRayInterface.xray(result).to(targetType);
    }

    public static Object convert(Object object, Class<?> clazz, Class<?> accessibleClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, SecurityException {
        InvocationHandler invocationHandler;
        if (object instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler((Proxy)object)) instanceof XRayInterface) {
            return ((XRayInterface)invocationHandler).getObject();
        }
        Object converted = Converter.createBaseObject(clazz);
        Object accessible = XRayInterface.xray(converted).to(accessibleClass);
        for (Method[] getSetPair : Converter.findProperties(accessibleClass)) {
            Method get = getSetPair[0];
            get.setAccessible(true);
            Method set = getSetPair[1];
            set.setAccessible(true);
            Object value = get.invoke(object, new Object[0]);
            set.invoke(accessible, value);
        }
        return converted;
    }

    private static Object createBaseObject(Class<?> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    private static List<Method[]> findProperties(Class<?> accessibleClass) {
        Converter converter = new Converter();
        for (Method method : accessibleClass.getDeclaredMethods()) {
            if (SignatureUtil.isSetter(method)) {
                converter.addSetter(method);
                continue;
            }
            if (!SignatureUtil.isGetter(method) && !SignatureUtil.isBooleanGetter(method)) continue;
            converter.addGetter(method);
        }
        return converter.getReadWritablePropertyPairs();
    }
}

