/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.xrayinterface;

import java.lang.reflect.Field;
import net.amygdalum.xrayinterface.ReflectionFailedException;

public final class FinalUtil {
    private static final String MODIFIERS = "modifiers";

    private FinalUtil() {
    }

    public static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) == 16;
    }

    public static void makeNonFinal(Field field) {
        try {
            Field modifiersField = Field.class.getDeclaredField(MODIFIERS);
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static void ensureNonFinal(Field field) {
        if (FinalUtil.isFinal(field)) {
            FinalUtil.makeNonFinal(field);
        }
    }
}

