/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.xrayinterface;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.amygdalum.xrayinterface.BindingQualifier;
import net.amygdalum.xrayinterface.BindingSignature;
import net.amygdalum.xrayinterface.Construct;
import net.amygdalum.xrayinterface.ConstructorInvoker;
import net.amygdalum.xrayinterface.Convert;
import net.amygdalum.xrayinterface.Delegate;
import net.amygdalum.xrayinterface.FieldGetter;
import net.amygdalum.xrayinterface.FieldSetter;
import net.amygdalum.xrayinterface.FinalUtil;
import net.amygdalum.xrayinterface.FixedType;
import net.amygdalum.xrayinterface.GetProperty;
import net.amygdalum.xrayinterface.MatchType;
import net.amygdalum.xrayinterface.MethodInvocationHandler;
import net.amygdalum.xrayinterface.MethodInvoker;
import net.amygdalum.xrayinterface.ReflectionFailedException;
import net.amygdalum.xrayinterface.SetProperty;
import net.amygdalum.xrayinterface.SignatureUtil;
import net.amygdalum.xrayinterface.StaticGetter;
import net.amygdalum.xrayinterface.StaticMethodInvoker;
import net.amygdalum.xrayinterface.StaticSetter;
import net.amygdalum.xrayinterface.Type;

public class InvocationResolver {
    private static Map<Class<? extends Annotation>, Function<Annotation, BindingSignature>> signatures = InvocationResolver.createSignatureMapping();
    private MethodHandles.Lookup lookup;
    private Map<String, Field> fieldCache;
    private Class<?> type;

    public InvocationResolver(Class<?> type) {
        this.type = type;
        this.lookup = MethodHandles.lookup();
        this.fieldCache = new HashMap<String, Field>();
    }

    public Class<?> getType() {
        return this.type;
    }

    private static Map<Class<? extends Annotation>, Function<Annotation, BindingSignature>> createSignatureMapping() {
        IdentityHashMap<Class<? extends Annotation>, Function<Annotation, BindingSignature>> signatures = new IdentityHashMap<Class<? extends Annotation>, Function<Annotation, BindingSignature>>();
        signatures.put(Construct.class, annotation -> new BindingSignature("", BindingQualifier.CONSTRUCTOR));
        signatures.put(Delegate.class, annotation -> new BindingSignature(((Delegate)annotation).value(), BindingQualifier.METHOD));
        signatures.put(SetProperty.class, annotation -> new BindingSignature(((SetProperty)annotation).value(), BindingQualifier.SET));
        signatures.put(GetProperty.class, annotation -> new BindingSignature(((GetProperty)annotation).value(), BindingQualifier.GET));
        return signatures;
    }

    protected MethodInvocationHandler findInvocationHandler(Method method) throws NoSuchMethodException, NoSuchFieldException {
        BindingSignature signature = this.resolveSignature(method);
        switch (signature.qualifier) {
            case SET: {
                return this.createSetterInvocator(signature.name, signature.params[0]);
            }
            case GET: {
                return this.createGetterInvocator(signature.name, signature.result);
            }
            case METHOD: {
                return this.createMethodInvocator(signature.name, signature.result, signature.params, signature.exceptions);
            }
            case CONSTRUCTOR: {
                return this.createConstructorInvocator(signature.result, signature.params, signature.exceptions);
            }
        }
        throw new NoSuchMethodException("invocation resolver failed resolving: " + method.toGenericString());
    }

    protected BindingSignature resolveSignature(Method method) throws NoSuchMethodException, NoSuchFieldException {
        BindingSignature signature = this.initSignature(method.getAnnotations());
        signature = this.completeSignature(signature, method);
        return signature;
    }

    private BindingSignature initSignature(Annotation[] annotations) {
        if (annotations == null) {
            return new BindingSignature();
        }
        return Stream.of(annotations).filter(annotation -> signatures.containsKey(annotation.annotationType())).map(annotation -> signatures.get(annotation.annotationType()).apply((Annotation)annotation)).findFirst().orElse(new BindingSignature());
    }

    private BindingSignature completeSignature(BindingSignature signature, Method method) throws NoSuchMethodException, NoSuchFieldException {
        ReflectiveOperationException exception = null;
        for (BindingQualifier type : signature.types()) {
            try {
                return this.completeSignature(type, signature, method);
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception instanceof NoSuchFieldException) {
            throw (NoSuchFieldException)exception;
        }
        if (exception instanceof NoSuchMethodException) {
            throw (NoSuchMethodException)exception;
        }
        return new BindingSignature(method.getName());
    }

    private BindingSignature completeSignature(BindingQualifier type, BindingSignature signature, Method method) throws NoSuchMethodException, NoSuchFieldException {
        switch (type) {
            case SET: {
                return this.completeSetter(signature, method);
            }
            case GET: {
                return this.completeGetter(signature, method);
            }
            case METHOD: {
                return this.completeMethod(signature, method);
            }
            case CONSTRUCTOR: {
                return this.completeConstructor(signature, method);
            }
        }
        throw new NoSuchMethodException();
    }

    private BindingSignature completeSetter(BindingSignature signature, Method method) throws NoSuchFieldException {
        if (!signature.hasName() && !SignatureUtil.isSetter(method)) {
            throw new NoSuchFieldException();
        }
        Type type = this.setterType(method);
        List<String> names = signature.hasName() ? Arrays.asList(signature.name) : SignatureUtil.computeFieldNames(SignatureUtil.propertyOf(method));
        for (String name : names) {
            try {
                Field field = this.findField(name, type);
                signature.params = new Type[]{type.matching(field.getType())};
                signature.name = name;
                signature.qualifier = BindingQualifier.SET;
                return signature;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        throw new NoSuchFieldException(SignatureUtil.fieldSignature(names, type.matchedType()));
    }

    private Type setterType(Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 1) {
            Parameter value = parameters[0];
            Class<?> valueClass = value.getType();
            Convert converted = value.getAnnotation(Convert.class);
            if (converted != null) {
                return new MatchType(this.name(converted, valueClass), valueClass);
            }
            return FixedType.fixed(valueClass);
        }
        return null;
    }

    private BindingSignature completeGetter(BindingSignature signature, Method method) throws NoSuchFieldException {
        if (!(signature.hasName() || SignatureUtil.isGetter(method) || SignatureUtil.isBooleanGetter(method))) {
            throw new NoSuchFieldException();
        }
        Type type = this.getterType(method);
        List<String> names = signature.hasName() ? Arrays.asList(signature.name) : SignatureUtil.computeFieldNames(SignatureUtil.propertyOf(method));
        for (String name : names) {
            try {
                Field field = this.findField(name, type);
                signature.result = type.matching(field.getType());
                signature.name = name;
                signature.qualifier = BindingQualifier.GET;
                return signature;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        throw new NoSuchFieldException(SignatureUtil.fieldSignature(names, type.matchedType()));
    }

    private Type getterType(Method method) {
        Class<?> valueClass = method.getReturnType();
        Convert converted = method.getAnnotation(Convert.class);
        if (converted != null) {
            return new MatchType(this.name(converted, valueClass), valueClass);
        }
        return FixedType.fixed(valueClass);
    }

    private String name(Convert converted, Class<?> valueClass) {
        String name = converted.value();
        if ("".equals(name)) {
            name = valueClass.getSimpleName();
        }
        return name;
    }

    private BindingSignature completeMethod(BindingSignature signature, Method method) throws NoSuchMethodException {
        String name = signature.hasName() ? signature.name : method.getName();
        Type result = this.resultType(method);
        Type[] params = this.paramTypes(method);
        Type[] exceptions = this.exceptionTypes(method);
        Method targetMethod = this.findMethod(name, result, params, exceptions);
        signature.result = result.matching(targetMethod.getReturnType());
        signature.params = this.matching(params, targetMethod.getParameterTypes());
        signature.exceptions = this.matching(exceptions, targetMethod.getExceptionTypes());
        signature.name = name;
        signature.qualifier = BindingQualifier.METHOD;
        return signature;
    }

    private Type resultType(Method method) {
        Class<?> valueClass = method.getReturnType();
        Convert converted = method.getAnnotation(Convert.class);
        if (converted != null) {
            return new MatchType(this.name(converted, valueClass), valueClass);
        }
        return FixedType.fixed(valueClass);
    }

    private Type[] paramTypes(Method method) {
        Parameter[] parameters = method.getParameters();
        Type[] types = new Type[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter value = parameters[i];
            Class<?> valueClass = value.getType();
            Convert converted = value.getAnnotation(Convert.class);
            types[i] = converted != null ? new MatchType(this.name(converted, valueClass), valueClass) : FixedType.fixed(valueClass);
        }
        return types;
    }

    private Type[] exceptionTypes(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        Type[] types = new Type[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            Class<?> valueClass = exceptions[i];
            types[i] = FixedType.fixed(valueClass);
        }
        return types;
    }

    private BindingSignature completeConstructor(BindingSignature signature, Method method) throws NoSuchMethodException {
        if (signature.qualifier == BindingQualifier.AUTO && !SignatureUtil.isConstructor(method)) {
            throw new NoSuchMethodException();
        }
        Type result = this.resultType(method);
        Type[] params = this.paramTypes(method);
        Type[] exceptions = this.exceptionTypes(method);
        Constructor<?> targetMethod = this.findConstructor(result, params, exceptions);
        signature.result = result.matching(targetMethod.getDeclaringClass());
        signature.params = this.matching(params, targetMethod.getParameterTypes());
        signature.exceptions = this.matching(exceptions, targetMethod.getExceptionTypes());
        signature.name = "";
        signature.qualifier = BindingQualifier.CONSTRUCTOR;
        return signature;
    }

    private Type[] matching(Type[] types, Class<?>[] matchingTypes) {
        for (int i = 0; i < types.length; ++i) {
            types[i] = types[i].matching(matchingTypes[i]);
        }
        return types;
    }

    protected MethodInvocationHandler createSetterInvocator(String name, Type param) throws NoSuchFieldException {
        Field field = this.findField(name, param);
        FinalUtil.ensureNonFinal(field);
        return this.createSetterInvocator(field, param.convertedType());
    }

    private MethodInvocationHandler createSetterInvocator(Field field, Class<?> convertedPropertyType) throws NoSuchFieldException {
        try {
            MethodHandle getter = this.lookup.unreflectSetter(field);
            if (Modifier.isStatic(field.getModifiers())) {
                return new StaticSetter(field.getName(), getter, convertedPropertyType);
            }
            return new FieldSetter(field.getName(), getter, convertedPropertyType);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionFailedException(e);
        }
    }

    protected MethodInvocationHandler createGetterInvocator(String name, Type result) throws NoSuchFieldException {
        Field field = this.findField(name, result);
        return this.createGetterInvocator(field, result.convertedType());
    }

    private MethodInvocationHandler createGetterInvocator(Field field, Class<?> convertedPropertyType) throws NoSuchFieldException {
        try {
            MethodHandle getter = this.lookup.unreflectGetter(field);
            if (Modifier.isStatic(field.getModifiers())) {
                return new StaticGetter(field.getName(), getter, convertedPropertyType);
            }
            return new FieldGetter(field.getName(), getter, convertedPropertyType);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionFailedException(e);
        }
    }

    protected Field findField(String name, Type type) throws NoSuchFieldException {
        for (Class<?> currentClass = this.type; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = this.fieldCache.get(name);
                if (field == null) {
                    field = currentClass.getDeclaredField(name);
                    field.setAccessible(true);
                    this.fieldCache.put(name, field);
                }
                if (!type.matches(field.getType())) continue;
                return field;
            }
            catch (NoSuchFieldException field) {
                // empty catch block
            }
        }
        Class<?> fieldType = type.matchedType();
        throw new NoSuchFieldException(SignatureUtil.fieldSignature(name, fieldType));
    }

    protected MethodInvocationHandler createMethodInvocator(String name, Type result, Type[] params, Type[] exceptions) throws NoSuchMethodException {
        Method method = this.findMethod(name, result, params, exceptions);
        return this.createMethodInvocator(method, result, params);
    }

    private MethodInvocationHandler createMethodInvocator(Method method, Type result, Type[] params) throws NoSuchMethodException {
        try {
            MethodHandle methodHandle = this.lookup.unreflect(method);
            if (Modifier.isStatic(method.getModifiers())) {
                return new StaticMethodInvoker(method.getName(), methodHandle, result.convertedType(), Type.convertedTypes(params));
            }
            return new MethodInvoker(method.getName(), methodHandle, result.convertedType(), Type.convertedTypes(params));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionFailedException(e);
        }
    }

    protected Method findMethod(String name, Type result, Type[] params, Type[] exceptions) throws NoSuchMethodException {
        boolean weakMatching = Type.isWeakMatching(params);
        Class<?>[] paramTypes = Type.matchedTypes(params);
        Object[] exceptionTypes = Type.matchedTypes(exceptions);
        for (Class<?> currentClass = this.type; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            try {
                Method candidate;
                Method method = candidate = weakMatching ? this.matchMethod(currentClass, name, params) : this.matchStrong(currentClass, name, paramTypes);
                if (!result.matches(candidate.getReturnType()) || !Arrays.equals(exceptionTypes, candidate.getExceptionTypes())) continue;
                candidate.setAccessible(true);
                return candidate;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new NoSuchMethodException(SignatureUtil.methodSignature(name, result.matchedType(), paramTypes, exceptionTypes));
    }

    private Method matchMethod(Class<?> currentClass, String name, Type[] params) throws NoSuchMethodException {
        return Stream.of(currentClass.getDeclaredMethods()).filter(method -> name.equals(method.getName())).filter(method -> Type.matches(params, method.getParameterTypes())).findFirst().orElseThrow(() -> new NoSuchMethodException());
    }

    private Method matchStrong(Class<?> currentClass, String name, Class<?>[] paramTypes) throws NoSuchMethodException {
        return currentClass.getDeclaredMethod(name, paramTypes);
    }

    protected MethodInvocationHandler createConstructorInvocator(Type result, Type[] params, Type[] exceptions) throws NoSuchMethodException {
        Constructor<?> constructor = this.findConstructor(result, params, exceptions);
        return this.createConstructorInvocator(constructor, result, params);
    }

    private MethodInvocationHandler createConstructorInvocator(Constructor<?> constructor, Type result, Type[] params) throws NoSuchMethodException {
        try {
            return new ConstructorInvoker(this.lookup.unreflectConstructor(constructor), result.convertedType(), Type.convertedTypes(params));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionFailedException(e);
        }
    }

    protected Constructor<?> findConstructor(Type result, Type[] params, Type[] exceptions) throws NoSuchMethodException {
        Class<?>[] paramTypes = Type.matchedTypes(params);
        Object[] exceptionTypes = Type.matchedTypes(exceptions);
        for (Class<?> currentClass = this.type; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            try {
                Constructor<?> candidate = currentClass.getDeclaredConstructor(paramTypes);
                if (!result.matches(this.type) || !Arrays.equals(exceptionTypes, candidate.getExceptionTypes())) continue;
                candidate.setAccessible(true);
                return candidate;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new NoSuchMethodException(SignatureUtil.methodSignature("<init>", this.type, paramTypes, exceptionTypes));
    }
}

