/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.xrayinterface;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.amygdalum.xrayinterface.BoxingUtil;
import net.amygdalum.xrayinterface.Convert;

public final class SignatureUtil {
    public static final String CONSTRUCTOR = "new";
    public static final String IS = "is";
    public static final String GET = "get";
    public static final String SET = "set";

    private SignatureUtil() {
    }

    public static boolean isConstructor(Method method) {
        String name = method.getName();
        return name.startsWith(CONSTRUCTOR) && name.endsWith(method.getReturnType().getSimpleName()) && method.getReturnType() != Void.TYPE && !method.getReturnType().isPrimitive();
    }

    public static boolean isBooleanGetter(Method method) {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        Class<?> returnType = BoxingUtil.getUnboxed(method.getReturnType());
        return name.length() > 2 && name.startsWith(IS) && parameterTypes.length == 0 && exceptionTypes.length == 0 && returnType == Boolean.TYPE;
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        Class<?> returnType = BoxingUtil.getUnboxed(method.getReturnType());
        return name.length() > 3 && name.startsWith(GET) && parameterTypes.length == 0 && exceptionTypes.length == 0 && returnType != Void.TYPE;
    }

    public static boolean isSetter(Method method) {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        Class<?> returnType = BoxingUtil.getUnboxed(method.getReturnType());
        return name.length() > 3 && name.startsWith(SET) && parameterTypes.length == 1 && exceptionTypes.length == 0 && returnType == Void.TYPE;
    }

    public static String propertyOf(Method method) {
        String name = method.getName();
        if (SignatureUtil.isSetter(method) || SignatureUtil.isGetter(method)) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        if (SignatureUtil.isBooleanGetter(method)) {
            return Character.toLowerCase(name.charAt(2)) + name.substring(3);
        }
        return name;
    }

    public static Class<?> propertyTypeOf(Method method) {
        if (SignatureUtil.isSetter(method)) {
            return method.getParameterTypes()[0];
        }
        if (SignatureUtil.isGetter(method) || SignatureUtil.isBooleanGetter(method)) {
            return method.getReturnType();
        }
        return null;
    }

    public static Annotation[] propertyAnnotationsOf(Method method) {
        if (SignatureUtil.isSetter(method)) {
            return method.getParameterAnnotations()[0];
        }
        if (SignatureUtil.isGetter(method) || SignatureUtil.isBooleanGetter(method)) {
            return method.getAnnotations();
        }
        return null;
    }

    public static List<String> computeFieldNames(String fieldPattern) {
        char firstCharUC = Character.toUpperCase(fieldPattern.charAt(0));
        char firstCharLC = Character.toLowerCase(fieldPattern.charAt(0));
        String lastChars = fieldPattern.substring(1);
        if (fieldPattern.toUpperCase().equals(fieldPattern)) {
            return Arrays.asList(firstCharUC + lastChars, firstCharLC + lastChars);
        }
        return Arrays.asList(firstCharLC + lastChars, firstCharUC + lastChars);
    }

    public static String fieldSignature(String fieldName, Class<?> type) {
        return SignatureUtil.fieldSignature(Arrays.asList(fieldName), type);
    }

    public static String fieldSignature(List<String> fieldNames, Class<?> type) {
        StringBuilder buffer = new StringBuilder().append(SignatureUtil.typeName(type)).append(' ');
        Iterator<String> iterator = fieldNames.iterator();
        if (iterator.hasNext()) {
            buffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            buffer.append('|');
            buffer.append(iterator.next());
        }
        return buffer.toString();
    }

    public static String methodSignature(String methodName, Class<?> resultType, Class<?>[] parameterTypes, Class<?>[] exceptionTypes) {
        return SignatureUtil.typeName(resultType) + ' ' + methodName + SignatureUtil.parameters(parameterTypes) + SignatureUtil.throwsClause(exceptionTypes);
    }

    private static String throwsClause(Class<?>[] exceptionTypes) {
        if (exceptionTypes.length == 0) {
            return "";
        }
        return " throws " + SignatureUtil.exceptions(exceptionTypes);
    }

    private static String parameters(Class<?>[] parameterTypes) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        if (parameterTypes.length > 0) {
            buffer.append(SignatureUtil.typeName(parameterTypes[0]));
        }
        for (int i = 1; i < parameterTypes.length; ++i) {
            buffer.append(',').append(SignatureUtil.typeName(parameterTypes[i]));
        }
        buffer.append(')');
        return buffer.toString();
    }

    private static String exceptions(Class<?>[] exceptionTypes) {
        StringBuilder buffer = new StringBuilder();
        if (exceptionTypes.length > 0) {
            buffer.append(SignatureUtil.typeName(exceptionTypes[0]));
        }
        for (int i = 1; i < exceptionTypes.length; ++i) {
            buffer.append(", ").append(SignatureUtil.typeName(exceptionTypes[i]));
        }
        return buffer.toString();
    }

    private static String typeName(Class<?> clazz) {
        if (clazz == null) {
            return "<unknown>";
        }
        return clazz.getSimpleName();
    }

    public static String findTargetTypeName(Annotation[] annotations, Class<?> defaultType) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != Convert.class) continue;
            Convert convertible = (Convert)annotation;
            String name = convertible.value();
            if (name.isEmpty()) {
                return defaultType.getSimpleName();
            }
            return name;
        }
        return null;
    }
}

