/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.xrayinterface;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.amygdalum.xrayinterface.SignatureUtil;
import net.amygdalum.xrayinterface.XRayInterface;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class XRayMatcher
extends TypeSafeMatcher<Class<?>> {
    private Class<?> interfaceClazz;

    public XRayMatcher(Class<?> interfaceClazz) {
        this.interfaceClazz = interfaceClazz;
    }

    public static XRayMatcher providesFeaturesOf(Class<?> interfaceClazz) {
        return new XRayMatcher(interfaceClazz);
    }

    public void describeTo(Description description) {
        description.appendText("can unlock features of ").appendValue(this.interfaceClazz);
    }

    protected void describeMismatchSafely(Class<?> item, Description mismatchDescription) {
        List<Method> conflicts = XRayInterface.xray(item).unMappable(this.interfaceClazz);
        if (!conflicts.isEmpty()) {
            mismatchDescription.appendText("cannot map following members in ").appendValue(item).appendText(": ").appendList("\n", "\n", "", this.describe(conflicts));
        }
    }

    private List<SelfDescribing> describe(List<Method> conflicts) {
        ArrayList<SelfDescribing> descriptions = new ArrayList<SelfDescribing>(conflicts.size());
        for (Method conflict : conflicts) {
            descriptions.add(new Signature(SignatureUtil.methodSignature(conflict.getName(), conflict.getReturnType(), conflict.getParameterTypes(), conflict.getExceptionTypes())));
        }
        return descriptions;
    }

    protected boolean matchesSafely(Class<?> item) {
        return XRayInterface.xray(item).unMappable(this.interfaceClazz).isEmpty();
    }

    private final class Signature
    implements SelfDescribing {
        private final String signature;

        private Signature(String signature) {
            this.signature = signature;
        }

        public void describeTo(Description description) {
            description.appendText(this.signature);
        }
    }
}

