/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.jbvext.annotations.date.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.andreinc.jbvext.annotations.date.Before;

public class BeforeValidator
implements ConstraintValidator<Before, Date> {
    private Before annotation;

    public void initialize(Before constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(Date value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.annotation.format());
        try {
            Date beforeDate = sdf.parse(this.annotation.value());
            boolean isBefore = value.before(beforeDate);
            return isBefore;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

