/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.jbvext.annotations.digits.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.andreinc.jbvext.annotations.digits.MaxDigits;

public class MaxDigitsDoubleValidator
implements ConstraintValidator<MaxDigits, Double> {
    private MaxDigits annotation;

    public void initialize(MaxDigits constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(Double value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        Double maxDigitsValue = Double.valueOf(this.annotation.value());
        int result = Double.compare(value, maxDigitsValue);
        if (0 == result) {
            return true;
        }
        if (result < 0) {
            return true;
        }
        if (result > 0) {
            return false;
        }
        throw new IllegalArgumentException("How this could be possible");
    }
}

