/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.jbvext.annotations.digits.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.andreinc.jbvext.annotations.digits.MinDigits;

public class MinDigitsDoubleValidator
implements ConstraintValidator<MinDigits, Double> {
    private MinDigits annotation;

    public void initialize(MinDigits constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(Double value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        Double minDigitsValue = Double.valueOf(this.annotation.value());
        int result = Double.compare(value, minDigitsValue);
        if (0 == result) {
            return true;
        }
        if (result < 0) {
            return false;
        }
        if (result > 0) {
            return true;
        }
        throw new IllegalArgumentException("How this could be possible");
    }
}

