/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.jbvext.annotations.str.validators;

import java.util.function.Function;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.andreinc.jbvext.annotations.str.Parseable;
import net.andreinc.jbvext.annotations.str.ParseableType;

public class ParseableValidator
implements ConstraintValidator<Parseable, String> {
    private Parseable annotation;

    public void initialize(Parseable constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value) {
            return false;
        }
        ParseableType type = this.annotation.value();
        switch (type) {
            case TO_INT: {
                return this.catcher(value, Integer::parseInt);
            }
            case TO_DOUBLE: {
                return this.catcher(value, Double::parseDouble);
            }
            case TO_LONG: {
                return this.catcher(value, Long::parseLong);
            }
            case TO_SHORT: {
                return this.catcher(value, Short::parseShort);
            }
            case TO_FLOAT: {
                return this.catcher(value, Float::parseFloat);
            }
        }
        return false;
    }

    private <T> boolean catcher(String value, Function<String, T> function) {
        try {
            function.apply(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

