/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.jbvext.annotations.str.validators;

import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.andreinc.jbvext.annotations.str.Password;

public class PasswordValidator
implements ConstraintValidator<Password, String> {
    private static final Set<Character> SPECIAL_CHARS = "\"/*!@#$%^&*()\\\"{}_[]|\\\\?/<>,.\"".chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toSet());
    private Password annotation;

    public void initialize(Password constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value) {
            return false;
        }
        if (value.length() < this.annotation.minSize() || value.length() >= this.annotation.maxSize()) {
            return false;
        }
        int upperCase = 0;
        int lowerCase = 0;
        int specialChar = 0;
        int digits = 0;
        for (int i = 0; i < value.length(); ++i) {
            char chr = value.charAt(i);
            if (Character.isUpperCase(chr)) {
                ++upperCase;
                continue;
            }
            if (Character.isLowerCase(chr)) {
                ++lowerCase;
                continue;
            }
            if (SPECIAL_CHARS.contains(Character.valueOf(chr))) {
                ++specialChar;
                continue;
            }
            if (Character.isDigit(chr)) {
                ++digits;
                continue;
            }
            if (chr != ' ' || !this.annotation.allowSpace()) continue;
            return false;
        }
        if (this.annotation.containsDigits() && digits <= 0) {
            return false;
        }
        if (this.annotation.containsLowerCase() && lowerCase <= 0) {
            return false;
        }
        if (this.annotation.containsUpperCase() && upperCase <= 0) {
            return false;
        }
        return !this.annotation.containsSpecialChar() || specialChar > 0;
    }
}

