/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.markovneat;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.andreinc.markovneat.MChain;
import net.andreinc.markovneat.MProb;
import net.andreinc.markovneat.MState;

public class MChainText
extends MChain<String> {
    private static final Pattern PT_PATTERN = Pattern.compile("[\\p{Punct}\\s]+");

    public MChainText() {
    }

    public MChainText(int noStates) {
        super(noStates);
    }

    public MChainText(int noStates, Random random) {
        super(noStates, random);
    }

    public void train(Path path) {
        try {
            this.train(Files.readAllLines(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void train(List<String> lines) {
        Iterator wordsIt = lines.stream().map(line -> line.replaceAll("\"", "")).map(MChainText::split).map(words -> words.stream().map(word -> word.trim().toLowerCase()).filter(word -> !"".equals(word)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList()).iterator();
        this.train(wordsIt);
    }

    public String generateText(MState<String> state, int approximateLength) {
        if (this.chain.isEmpty()) {
            throw new IllegalArgumentException("Markov chain is empty. Please train the chain first.");
        }
        if (approximateLength < 0) {
            throw new IllegalArgumentException("The approximate text length cannot be a negative number.");
        }
        if (!this.chain.containsKey(state)) {
            throw new IllegalArgumentException("The initial state cannot be found in the Markov Chain. Please use an existing state.");
        }
        StringBuilder result = new StringBuilder();
        MState<String> currentState = state;
        while (MChainText.isPunctuation(currentState.data().getFirst())) {
            currentState = this.randomState();
        }
        MChainText.appendState(result, currentState);
        if (result.length() > approximateLength) {
            return result.append(".").toString();
        }
        while (result.length() <= approximateLength) {
            String cElement;
            if (!this.chain.containsKey(currentState)) {
                currentState = this.randomState();
            }
            if (!MChainText.isPunctuation(cElement = (String)((MProb)this.chain.get(currentState)).next())) {
                result.append(" ");
            }
            if (result.charAt(result.length() - 2) == '.') {
                result.append(MChainText.capital(cElement));
            } else {
                result.append(cElement);
            }
            currentState = currentState.nextState(cElement);
        }
        return result.append(".").toString();
    }

    public String generateText(int approximateLength) {
        return this.generateText(this.randomState(), approximateLength);
    }

    private static void appendState(StringBuilder buff, MState<String> firstState) {
        for (String element : firstState.data()) {
            if (!MChainText.isPunctuation(element)) {
                buff.append(' ');
            }
            buff.append(element);
        }
        buff.deleteCharAt(0);
        char newChar = Character.toUpperCase(buff.charAt(0));
        buff.deleteCharAt(0).insert(0, newChar);
    }

    private static String capital(String element) {
        return element.substring(0, 1).toUpperCase() + element.substring(1);
    }

    private static boolean isPunctuation(String element) {
        return PT_PATTERN.matcher(element).matches();
    }

    private static final List<String> split(String source) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = PT_PATTERN.matcher(source);
        int last = 0;
        int start = 0;
        while (matcher.find()) {
            int end;
            start = matcher.start();
            if (last != start) {
                result.add(source.substring(last, start));
            }
            String delim = matcher.group();
            result.add(delim);
            last = end = matcher.end();
        }
        if (last != source.length()) {
            result.add(source.substring(last));
        }
        return result;
    }
}

