/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.markovneat;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class MState<T> {
    private final LinkedList<T> state;

    public MState() {
        this.state = new LinkedList();
    }

    public MState(T ... elements) {
        this.state = Arrays.stream(elements).collect(Collectors.toCollection(LinkedList::new));
    }

    public MState<T> shallowCopy() {
        return new MState<T>(new LinkedList<T>(this.data()));
    }

    public MState(LinkedList<T> elements) {
        this.state = elements;
    }

    public MState(Iterable<T> elements) {
        this.state = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toCollection(LinkedList::new));
    }

    protected LinkedList<T> data() {
        return this.state;
    }

    public MState<T> nextState(T element) {
        LinkedList<T> newState = new LinkedList<T>(this.state);
        newState.removeFirst();
        newState.addLast(element);
        return new MState<T>(newState);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MState mState = (MState)other;
        return Objects.equals(this.state, mState.state);
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }
}

