package net.andreinc.mockneat.types.enums;

/**
 * Copyright 2017, Andrei N. Ciobanu

 Permission is hereby granted, free of charge, to any user obtaining a copy of this software and associated
 documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 persons to whom the Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. PARAM NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER PARAM AN ACTION OF CONTRACT, TORT OR
 OTHERWISE, ARISING FROM, FREE_TEXT OF OR PARAM CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS PARAM THE SOFTWARE.
 */

@SuppressWarnings("ImmutableEnumChecker")
public enum CurrencySymbolType {
    ALBANIA_LEK("Lek", "ALL", "Lek"),
    AFGHANISTAN_AFGHANI("Afghani", "AFN", "؋"),
    ARGENTINA_PESO("Peso", "ARS", "$"),
    ARUBA_GUILDER("Guilder", "AWG", "ƒ"),
    AUSTRALIA_DOLLAR("Dollar", "AUD", "$"),
    AZERBAIJAN_NEW_MANAT("New Manat", "AZN", "ман"),
    BAHAMAS_DOLLAR("Dollar", "BSD", "$"),
    BARBADOS_DOLLAR("Dollar", "BBD", "$"),
    BELARUS_RUBLE("Ruble", "BYN", "Br"),
    BELIZE_DOLLAR("Dollar", "BZD", "BZ$"),
    BERMUDA_DOLLAR("Dollar", "BMD", "$"),
    BOLIVIA_BOLIVIANO("Boliviano", "BOB", "$b"),
    BOSNIA_HERZEGOVINA_MARKA("Marka", "BAM", "KM"),
    BOTSWANA_PULA("Pula", "BWP", "P"),
    BULGARIA_LEV("Lev", "BGN", "лв"),
    BRAZIL_REAL("Real", "BRL", "R$"),
    BRUNEI_DARUSSALAM_DOLLAR("Dollar", "BND", "$"),
    CAMBODIA_RIEL("Riel", "KHR", "៛"),
    CANADA_DOLLAR("Dollar", "CAD", "$"),
    CAYMAN_ISLANDS_DOLLAR("Dollar", "KYD", "$"),
    CHILE_PESO("Dollar", "CLP", "$"),
    CHINA_YUAN_RENMIMBI("Yuan", "CNY", "¥"),
    COLOMBIA_PESO("Peso", "COP", "$"),
    COSTA_RICA_COLON("Colon", "CRC", "₡"),
    CROATIA_KUNA("Kuna", "HRK", "kn"),
    CUBA_PESO("Peso", "CUP", "₱"),
    CZECH_REPUBLIC_KORUNA("Koruna", "CZK", "Kč"),
    DENMARK_KRONE("Krone", "DKK", "kr"),
    DOMINICAN_REPUBLIC_PESO("Peso", "DOP", "RD$"),
    EAST_CARIBBEAN_DOLLAR("Dollar", "XCD", "$"),
    EGYPT_POUND("Pound", "EGP", "£"),
    EL_SALVADOR_COLON("Colon", "SVC", "$"),
    EURO_MEMBER_COUNTRIES("Euro", "EUR", "€"),
    FALKLAND_ISLANDS_POUND("Pound", "FKP", "£"),
    FIJI_DOLLAR("Dollar", "FJD", "$"),
    GHANA_CEDI("Cedi", "GHS", "¢"),
    GIBRALTAR_POUND("Pound", "GIP", "£"),
    GUATEMALA_QUETZAL("Quetzal", "GTQ", "Q"),
    GUERNSEY_POUND("Pound", "GGP", "£"),
    GUYANA_DOLLAR("Dollar", "GYD", "$"),
    HONDURAS_LEMPIRA("Lempira", "HNL", "L"),
    HONG_KONG_DOLLAR("Dollar", "HKD", "$"),
    HUNGARY_FORINT("Forint", "HUF", "Ft"),
    ICELAND_KRONA("Krona", "ISK", "kr"),
    INDIA_RUPEE("Rupee", "INR", "₹"),
    INDONESIA_RUPIAH("Rupiah", "IDR", "Rp"),
    IRAN_RIAL("Rial", "IRR", "﷼"),
    ISLE_OF_MAN_POUND("Pound", "IMP", "£"),
    ISRAEL_SHEKEL("Shekel", "ILS", "₪"),
    JAMAICA_DOLLAR("Dollar", "JMD", "J$"),
    JAPAN_YEN("Yen", "JPY", "¥"),
    JERSEY_POUND("Pound", "JEP", "£"),
    KAZAKHSTAN_TENGE("Tenge", "KZT", "лв"),
    KOREA_NORTH_WON("Won", "KPW", "₩"),
    KOREA_SOUTH_WON("Won", "KRW", "₩"),
    KYRGYZSTAN_SOM("Som", "KGS", "лв"),
    LAOS_KIP("kip", "LAK", "₭"),
    LATVIA_LAT("Lat", "LVL", "Ls"),
    LEBANON_POUND("Pound", "LBP", "£"),
    LIBERIA_DOLLAR("Dollar", "LRD", "$"),
    LITHUANIA_LITAS("Litas", "LTL", "Lt"),
    MACEDONIA_DENAR("Denar", "MKD", "ден"),
    MALAYSIA_RINGGIT("Ringgit", "MYR", "RM"),
    MAURITIUS_RUPEE("Rupee", "MUR", "₨"),
    MEXICO_PESO("Peso", "MXN", "$"),
    MONGOLIA_TUGHRIK("Tughrik", "MNT", "₮"),
    MOZAMBIQUE_METICAL("Metical", "MZN", "MT"),
    NAMIBIA_DOLLAR("Dollar", "NAD", "$"),
    NEPAL_RUPEE("Rupee", "NPR", "₨"),
    NETHERLANDS_ANTILLES_GUILDER("Guilder", "ANG", "ƒ"),
    NEW_ZEELAND_DOLLAR("Dollar", "NZD", "$"),
    NICARAGUA_CORDOBA("Cordoba", "NIO", "C$"),
    NIGERIA_NAIRA("Naira", "NGN", "₦"),
    NORWAY_KRONE("Krone", "NOK", "kr"),
    OMAN_RIAL("Rial", "OMR", "﷼"),
    PAKISTAN_RUPEE("Rupee", "PKR", "₨"),
    PANAMA_BALBOA("Balboa", "PAB", "B/."),
    PARAGUAY_GUARANI("Guarani", "PYG", "Gs"),
    PERU_NUEVO_SOL("Nuevo Sol", "PEN", "S/."),
    PHILIPPINES_PESO("Peso", "PHP", "₱"),
    POLAND_ZLOTY("Zloty", "PLN", "zł"),
    QATAR_RIYAL("Riyal", "QAR", "﷼"),
    ROMANIA_NEW_LEU("Leu", "RON", "lei"),
    RUSSIA_RUBLE("Ruble", "RUB", "\u20BD"),
    SAINT_HELENA_POUND("Pound", "SHP", "£"),
    SAUDI_ARABIA_RIYAL("Riyal", "SAR", "﷼"),
    SERBIA_DINAR("Dinar", "RSD", "Дин."),
    SEYCHELLES_RUPEE("Rupee", "SCR", "₨"),
    SINGAPORE_DOLLAR("Dollar", "SGD", "$"),
    SOLOMON_ISLANDS_DOLLAR("Dollar", "SBD", "$"),
    SOMALIA_SHILLING("Shilling", "SOS", "S"),
    SOUTH_AFRICA_RAND("Rand", "ZAR", "R"),
    SRI_LANKA_RUPEE("Rupee", "LKR", "₨"),
    SWEDEN_KRONA("Krona", "SEK", "kr"),
    SWITZERLAND_FRANC("Franc", "CHF", "CHF"),
    SURINAME_DOLLAR("Dollar", "SRD", "$"),
    SYRIA_POUND("Pound", "SYP", "£"),
    TAIWAN_NEW_DOLLAR("New Dollar", "TWD", "NT$"),
    THAILAND_BAHT("Baht", "THB", "฿"),
    TRINIDAD_AND_TOBAGO_DOLLAR("Dollar", "TTD", "TT$"),
    TURKEY_LIRA("Lira", "TRY", "₺"),
    TUVALU_DOLLAR("Dollar", "TVD", "$"),
    UKRAINE_HRYVNA("Hryvna", "UAH", "₴"),
    UNITED_KINGDOM_POUND("Pound", "GBP", "£"),
    UNITED_STATES_DOLLAR("Dollar", "USD", "$"),
    URUGUAY_PESO("Peso", "UYU", "$U"),
    UZBEKISTAN_SOM("Som", "UZS", "лв"),
    VENEZUELA_BOLIVAR_FORTE("Bolivar Fuerte", "VEF", "Bs"),
    VIET_NAM_DONG("Dong", "VND", "₫"),
    YEMEN_RIAL("Rial", "YER", "﷼"),
    ZIMBABWE_DOLLAR("Dollar", "ZWD", "Z$");

    private final String name;
    private final String code;
    private final String symbol;

    CurrencySymbolType(String name, String code, String symbol) {
        this.name = name;
        this.code = code;
        this.symbol = symbol;
    }

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getSymbol() {
        return symbol;
    }
}
