/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.abstraction;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.utils.ValidationUtils;

public interface MockUnitInt
extends MockUnit<Integer> {
    default public MockUnit<IntStream> intStream() {
        Supplier<IntStream> supp = () -> IntStream.generate(((Supplier)this.supplier())::get);
        return () -> supp;
    }

    default public MockUnit<int[]> arrayPrimitive(int size) {
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<int[]> supp = () -> {
            int[] result = new int[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Integer)this.val();
            });
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Integer[]> array(int size) {
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Integer[]> supp = () -> {
            Integer[] result = new Integer[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Integer)this.val();
            });
            return result;
        };
        return () -> supp;
    }
}

