/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.utils.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.MarkovChainType;

public class FileManager {
    private static final String DICT_FOLDER = "dicts/";
    private static final String MARKOV_FOLDER = "markov/";
    private static final FileManager fileManager = new FileManager();
    private static final ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private static final Map<String, List<String>> JAR_INTERNAL = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> JAR_EXTERNAL = new HashMap<String, List<String>>();

    public static FileManager getInstance() {
        return fileManager;
    }

    public List<String> getLines(String path) {
        if (!JAR_EXTERNAL.containsKey(path)) {
            try {
                List<String> lines = this.read(path);
                JAR_EXTERNAL.put(path, lines);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return JAR_EXTERNAL.get(path);
    }

    public List<String> getLines(DictType dictType) {
        String internal = this.getDictPath(dictType);
        if (!JAR_INTERNAL.containsKey(internal)) {
            try {
                List<String> lines = this.read(dictType);
                JAR_INTERNAL.put(internal, lines);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return JAR_INTERNAL.get(internal);
    }

    public Set<String> getUniqueLines(DictType dictType) {
        return new HashSet<String>(this.getLines(dictType));
    }

    private String getDictPath(DictType dictType) {
        return DICT_FOLDER + dictType.getFile();
    }

    private String getMarkovPath(MarkovChainType markovChainType) {
        return MARKOV_FOLDER + markovChainType.getFile();
    }

    private List<String> readInternal(String internal) throws IOException {
        try (BufferedReader buff = new BufferedReader(new InputStreamReader(Objects.requireNonNull(loader.getResourceAsStream(internal)), Charset.defaultCharset()));){
            List<String> list = buff.lines().collect(Collectors.toList());
            return list;
        }
    }

    public List<String> read(MarkovChainType markovChainType) throws IOException {
        return this.readInternal(this.getMarkovPath(markovChainType));
    }

    public List<String> read(DictType dictType) throws IOException {
        return this.readInternal(this.getDictPath(dictType));
    }

    public List<String> read(String key) throws IOException {
        Path p = Paths.get(key, new String[0]);
        try (Stream<String> stream = Files.lines(p);){
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }
}

