/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs;

import net.andrewcpu.elevenlabs.api.impl.AudioNativeAPI;
import net.andrewcpu.elevenlabs.api.impl.HistoryAPI;
import net.andrewcpu.elevenlabs.api.impl.ModelsAPI;
import net.andrewcpu.elevenlabs.api.impl.ProjectsAPI;
import net.andrewcpu.elevenlabs.api.impl.SampleAPI;
import net.andrewcpu.elevenlabs.api.impl.SpeechToSpeechAPI;
import net.andrewcpu.elevenlabs.api.impl.TextToSpeechAPI;
import net.andrewcpu.elevenlabs.api.impl.UserAPI;
import net.andrewcpu.elevenlabs.api.impl.VoiceAPI;

public class ElevenLabs {
    private static String API_KEY = null;
    private static HistoryAPI historyAPI;
    private static ModelsAPI modelsAPI;
    private static ProjectsAPI projectsAPI;
    private static SampleAPI sampleAPI;
    private static SpeechToSpeechAPI speechToSpeechAPI;
    private static TextToSpeechAPI textToSpeechAPI;
    private static UserAPI userAPI;
    private static VoiceAPI voiceAPI;
    private static AudioNativeAPI audioNativeAPI;
    private static String defaultModel;

    public static String getApiKey() {
        return API_KEY;
    }

    public static String getDefaultModel() {
        return defaultModel;
    }

    public static void setDefaultModel(String defaultModel) {
        ElevenLabs.defaultModel = defaultModel;
    }

    public static void setApiKey(String apiKey) {
        API_KEY = apiKey;
        ElevenLabs.initializeSubclasses();
    }

    private static void initializeSubclasses() {
        historyAPI = new HistoryAPI();
        modelsAPI = new ModelsAPI();
        projectsAPI = new ProjectsAPI();
        sampleAPI = new SampleAPI();
        speechToSpeechAPI = new SpeechToSpeechAPI();
        textToSpeechAPI = new TextToSpeechAPI();
        userAPI = new UserAPI();
        voiceAPI = new VoiceAPI();
        audioNativeAPI = new AudioNativeAPI();
    }

    public static AudioNativeAPI getAudioNativeAPI() {
        return audioNativeAPI;
    }

    public static HistoryAPI getHistoryAPI() {
        return historyAPI;
    }

    public static ModelsAPI getModelsAPI() {
        return modelsAPI;
    }

    public static ProjectsAPI getProjectsAPI() {
        return projectsAPI;
    }

    public static SampleAPI getSampleAPI() {
        return sampleAPI;
    }

    public static SpeechToSpeechAPI getSpeechToSpeechAPI() {
        return speechToSpeechAPI;
    }

    public static TextToSpeechAPI getTextToSpeechAPI() {
        return textToSpeechAPI;
    }

    public static UserAPI getUserAPI() {
        return userAPI;
    }

    public static VoiceAPI getVoiceAPI() {
        return voiceAPI;
    }

    static {
        defaultModel = "eleven_monolingual_v1";
    }
}

