/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.api.impl;

import java.io.InputStream;
import java.util.List;
import net.andrewcpu.elevenlabs.api.ElevenLabsAPI;
import net.andrewcpu.elevenlabs.model.projects.Chapter;
import net.andrewcpu.elevenlabs.model.projects.ChapterSnapshot;
import net.andrewcpu.elevenlabs.model.projects.Project;
import net.andrewcpu.elevenlabs.model.projects.ProjectSnapshot;
import net.andrewcpu.elevenlabs.model.request.AddProjectRequest;
import net.andrewcpu.elevenlabs.requests.projects.DeleteChapterByIdRequest;
import net.andrewcpu.elevenlabs.requests.projects.DeleteProjectByIdRequest;
import net.andrewcpu.elevenlabs.requests.projects.GetChapterByIdRequest;
import net.andrewcpu.elevenlabs.requests.projects.GetChapterSnapshotsRequest;
import net.andrewcpu.elevenlabs.requests.projects.GetProjectByIdRequest;
import net.andrewcpu.elevenlabs.requests.projects.GetProjectChaptersRequest;
import net.andrewcpu.elevenlabs.requests.projects.GetProjectSnapshotsRequest;
import net.andrewcpu.elevenlabs.requests.projects.GetProjectsRequest;
import net.andrewcpu.elevenlabs.requests.projects.PostAddProjectRequest;
import net.andrewcpu.elevenlabs.requests.projects.PostConvertChapterRequest;
import net.andrewcpu.elevenlabs.requests.projects.PostConvertProjectRequest;
import net.andrewcpu.elevenlabs.requests.projects.PostStreamChapterSnapshotAudioRequest;
import net.andrewcpu.elevenlabs.requests.projects.PostStreamProjectSnapshotAudioRequest;

public class ProjectsAPI
extends ElevenLabsAPI {
    public List<Project> getProjects() {
        return this.sendRequest(new GetProjectsRequest()).getProjects();
    }

    public Project addProject(AddProjectRequest addProjectRequest) {
        return this.sendRequest(new PostAddProjectRequest(addProjectRequest)).getProject();
    }

    public Project getProject(String id) {
        return this.sendRequest(new GetProjectByIdRequest(id));
    }

    public String deleteProject(String projectId) {
        return this.sendRequest(new DeleteProjectByIdRequest(projectId));
    }

    public String convertProject(String projectId) {
        return this.sendRequest(new PostConvertProjectRequest(projectId));
    }

    public List<ProjectSnapshot> getProjectSnapshots(String projectId) {
        return this.sendRequest(new GetProjectSnapshotsRequest(projectId)).getSnapshots();
    }

    public InputStream getProjectSnapshotAudioStream(String projectId, String projectSnapshotId) {
        return this.sendRequest(new PostStreamProjectSnapshotAudioRequest(projectId, projectSnapshotId));
    }

    public List<Chapter> getChapters(String projectId) {
        return this.sendRequest(new GetProjectChaptersRequest(projectId)).getChapters();
    }

    public Chapter getChapterById(String projectId, String chapterId) {
        return this.sendRequest(new GetChapterByIdRequest(projectId, chapterId));
    }

    public String deleteChapter(String projectId, String chapterId) {
        return this.sendRequest(new DeleteChapterByIdRequest(projectId, chapterId));
    }

    public String convertChapter(String projectId, String chapterId) {
        return this.sendRequest(new PostConvertChapterRequest(projectId, chapterId));
    }

    public List<ChapterSnapshot> getChapterSnapshots(String projectId, String chapterId) {
        return this.sendRequest(new GetChapterSnapshotsRequest(projectId, chapterId)).getSnapshots();
    }

    public InputStream getChapterSnapshotAudioStream(String projectId, String chapterId, String chapterSnapshotId) {
        return this.sendRequest(new PostStreamChapterSnapshotAudioRequest(projectId, chapterId, chapterSnapshotId));
    }
}

