/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.api.impl;

import java.io.File;
import java.io.InputStream;
import net.andrewcpu.elevenlabs.api.ElevenLabsAPI;
import net.andrewcpu.elevenlabs.enums.ElevenLabsVoiceModel;
import net.andrewcpu.elevenlabs.enums.StreamLatencyOptimization;
import net.andrewcpu.elevenlabs.model.voice.VoiceSettings;
import net.andrewcpu.elevenlabs.requests.sts.PostSpeechToSpeechRequest;
import net.andrewcpu.elevenlabs.requests.sts.PostSpeechToSpeechStreamedRequest;

public class SpeechToSpeechAPI
extends ElevenLabsAPI {
    public File generateSpeechToSpeech(String voiceId, VoiceSettings voiceSettings, String modelId, File audio) {
        return this.generateSpeechToSpeech(voiceId, voiceSettings, modelId, audio, StreamLatencyOptimization.getDefault());
    }

    public File generateSpeechToSpeech(String voiceId, VoiceSettings voiceSettings, String modelId, File audio, StreamLatencyOptimization latencyOptimization) {
        return this.sendRequest(new PostSpeechToSpeechRequest(voiceId, voiceSettings, audio, modelId, latencyOptimization));
    }

    public InputStream generateSpeechToSpeechStream(String voiceId, VoiceSettings voiceSettings, String modelId, File audio, StreamLatencyOptimization streamLatencyOptimization) {
        return this.sendRequest(new PostSpeechToSpeechStreamedRequest(voiceId, voiceSettings, audio, modelId, streamLatencyOptimization));
    }

    public InputStream generateSpeechToSpeechStream(String voiceId, VoiceSettings voiceSettings, String modelId, File audio) {
        return this.generateSpeechToSpeechStream(voiceId, voiceSettings, modelId, audio, StreamLatencyOptimization.getDefault());
    }

    public File generateSpeechToSpeech(String voiceId, VoiceSettings voiceSettings, ElevenLabsVoiceModel model, File audio) {
        return this.generateSpeechToSpeech(voiceId, voiceSettings, model.getModelId(), audio, StreamLatencyOptimization.getDefault());
    }

    public File generateSpeechToSpeech(String voiceId, VoiceSettings voiceSettings, ElevenLabsVoiceModel model, File audio, StreamLatencyOptimization latencyOptimization) {
        return this.sendRequest(new PostSpeechToSpeechRequest(voiceId, voiceSettings, audio, model.getModelId(), latencyOptimization));
    }

    public InputStream generateSpeechToSpeechStream(String voiceId, VoiceSettings voiceSettings, ElevenLabsVoiceModel model, File audio, StreamLatencyOptimization streamLatencyOptimization) {
        return this.sendRequest(new PostSpeechToSpeechStreamedRequest(voiceId, voiceSettings, audio, model.getModelId(), streamLatencyOptimization));
    }

    public InputStream generateSpeechToSpeechStream(String voiceId, VoiceSettings voiceSettings, ElevenLabsVoiceModel model, File audio) {
        return this.generateSpeechToSpeechStream(voiceId, voiceSettings, model.getModelId(), audio, StreamLatencyOptimization.getDefault());
    }
}

