/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.api.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.andrewcpu.elevenlabs.api.ElevenLabsAPI;
import net.andrewcpu.elevenlabs.model.response.CreateVoiceResponse;
import net.andrewcpu.elevenlabs.model.response.ProjectsModelResponse;
import net.andrewcpu.elevenlabs.model.voice.Voice;
import net.andrewcpu.elevenlabs.model.voice.VoiceSettings;
import net.andrewcpu.elevenlabs.requests.projects.GetProjectsRequest;
import net.andrewcpu.elevenlabs.requests.voices.DeleteVoiceRequest;
import net.andrewcpu.elevenlabs.requests.voices.GetDefaultVoiceSettingsRequest;
import net.andrewcpu.elevenlabs.requests.voices.GetVoiceRequest;
import net.andrewcpu.elevenlabs.requests.voices.GetVoiceSettingsRequest;
import net.andrewcpu.elevenlabs.requests.voices.GetVoicesRequest;
import net.andrewcpu.elevenlabs.requests.voices.PostAddVoiceRequest;
import net.andrewcpu.elevenlabs.requests.voices.PostEditVoiceRequest;
import net.andrewcpu.elevenlabs.requests.voices.PostEditVoiceSettingsRequest;

public class VoiceAPI
extends ElevenLabsAPI {
    public List<Voice> getVoices() {
        return this.sendRequest(new GetVoicesRequest()).getVoices();
    }

    public VoiceSettings getDefaultVoiceSettings() {
        return this.sendRequest(new GetDefaultVoiceSettingsRequest());
    }

    public VoiceSettings getVoiceSettings(String voiceId) {
        return this.sendRequest(new GetVoiceSettingsRequest(voiceId));
    }

    public Voice getVoice(String voiceId) {
        return this.sendRequest(new GetVoiceRequest(voiceId));
    }

    public Voice getVoice(String voiceId, boolean withSettings) {
        return this.sendRequest(new GetVoiceRequest(voiceId, withSettings));
    }

    public ProjectsModelResponse getProjects() {
        return this.sendRequest(new GetProjectsRequest());
    }

    public String deleteVoice(String voiceId) {
        return this.sendRequest(new DeleteVoiceRequest(voiceId));
    }

    public String editVoiceSettings(String voiceId, VoiceSettings settings) {
        return this.sendRequest(new PostEditVoiceSettingsRequest(voiceId, settings));
    }

    public CreateVoiceResponse createVoice(String name, File[] files, String description, Map<String, String> labels) {
        return this.sendRequest(new PostAddVoiceRequest(name, files, description, labels));
    }

    public String editVoice(String voiceId, String name, File[] files, String description, Map<String, String> labels) {
        return this.sendRequest(new PostEditVoiceRequest(voiceId, name, files, description, labels));
    }
}

