/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.projects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.model.ElevenModel;
import net.andrewcpu.elevenlabs.model.projects.ChapterSnapshot;
import net.andrewcpu.elevenlabs.model.projects.Statistics;

public class Chapter
extends ElevenModel {
    @JsonProperty(value="chapter_id")
    private String chapterId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="last_conversion_date_unix")
    private long lastConversionDateUnix;
    @JsonProperty(value="conversion_progress")
    private double conversionProgress;
    @JsonProperty(value="can_be_downloaded")
    private boolean canBeDownloaded;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="statistics")
    private Statistics statistics;

    public String deleteChapter(String projectId) {
        return ElevenLabs.getProjectsAPI().deleteChapter(projectId, this.chapterId);
    }

    public String convertChapter(String projectId) {
        return ElevenLabs.getProjectsAPI().convertChapter(projectId, this.chapterId);
    }

    public List<ChapterSnapshot> getChapterSnapshots(String projectId) {
        return ElevenLabs.getProjectsAPI().getChapterSnapshots(projectId, this.chapterId);
    }

    public Chapter() {
    }

    public Chapter(String chapterId, String name, long lastConversionDateUnix, double conversionProgress, boolean canBeDownloaded, String state, Statistics statistics) {
        this.chapterId = chapterId;
        this.name = name;
        this.lastConversionDateUnix = lastConversionDateUnix;
        this.conversionProgress = conversionProgress;
        this.canBeDownloaded = canBeDownloaded;
        this.state = state;
        this.statistics = statistics;
    }

    @JsonIgnore
    public String getChapterId() {
        return this.chapterId;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public long getLastConversionDateUnix() {
        return this.lastConversionDateUnix;
    }

    @JsonIgnore
    public double getConversionProgress() {
        return this.conversionProgress;
    }

    @JsonIgnore
    public boolean isCanBeDownloaded() {
        return this.canBeDownloaded;
    }

    @JsonIgnore
    public String getState() {
        return this.state;
    }

    @JsonIgnore
    public Statistics getStatistics() {
        return this.statistics;
    }

    @JsonIgnore
    public String toString() {
        return "Chapter{chapterId='" + this.chapterId + "', name='" + this.name + "', lastConversionDateUnix=" + this.lastConversionDateUnix + ", conversionProgress=" + this.conversionProgress + ", canBeDownloaded=" + this.canBeDownloaded + ", state='" + this.state + "', statistics=" + this.statistics + "}";
    }
}

