/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.projects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.model.ElevenModel;
import net.andrewcpu.elevenlabs.model.projects.Chapter;
import net.andrewcpu.elevenlabs.model.projects.ChapterSnapshot;
import net.andrewcpu.elevenlabs.model.projects.ProjectSnapshot;
import net.andrewcpu.elevenlabs.model.request.AddProjectRequest;

public class Project
extends ElevenModel {
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="create_date_unix")
    private long unixCreateDate;
    @JsonProperty(value="default_title_voice_id")
    private String defaultTitleVoiceId;
    @JsonProperty(value="default_paragraph_voice_id")
    private String defaultParagraphVoiceId;
    @JsonProperty(value="default_model_id")
    private String defaultModelId;
    @JsonProperty(value="last_conversion_date_unix")
    private long lastConversionDateUnix;
    @JsonProperty(value="can_be_downloaded")
    private boolean canBeDownloaded;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="chapters")
    private List<Chapter> chapters;

    public static List<Project> getProjects() {
        return ElevenLabs.getProjectsAPI().getProjects();
    }

    public static Project addProject(AddProjectRequest builder) {
        return ElevenLabs.getProjectsAPI().addProject(builder);
    }

    public static Project getProjectById(String projectId) {
        return ElevenLabs.getProjectsAPI().getProject(projectId);
    }

    public List<Chapter> fetchUpdatedChapters() {
        this.chapters = ElevenLabs.getProjectsAPI().getChapters(this.projectId);
        return this.chapters;
    }

    public String deleteChapter(Chapter chapter) {
        return chapter.deleteChapter(this.projectId);
    }

    public String convertChapter(Chapter chapter) {
        return chapter.convertChapter(this.projectId);
    }

    public List<ChapterSnapshot> getChapterSnapshots(Chapter chapter) {
        return chapter.getChapterSnapshots(this.projectId);
    }

    public String deleteProject() {
        return ElevenLabs.getProjectsAPI().deleteProject(this.projectId);
    }

    public String convertProject() {
        return ElevenLabs.getProjectsAPI().convertProject(this.projectId);
    }

    public List<ProjectSnapshot> getSnapshots() {
        return ElevenLabs.getProjectsAPI().getProjectSnapshots(this.projectId);
    }

    public Chapter getChapterById(String chapterId) {
        return ElevenLabs.getProjectsAPI().getChapterById(this.projectId, chapterId);
    }

    public Project(String projectId, String name, long unixCreateDate, String defaultTitleVoiceId, String defaultParagraphVoiceId, String defaultModelId, long lastConversionDateUnix, boolean canBeDownloaded, String state, List<Chapter> chapters) {
        this.projectId = projectId;
        this.name = name;
        this.unixCreateDate = unixCreateDate;
        this.defaultTitleVoiceId = defaultTitleVoiceId;
        this.defaultParagraphVoiceId = defaultParagraphVoiceId;
        this.defaultModelId = defaultModelId;
        this.lastConversionDateUnix = lastConversionDateUnix;
        this.canBeDownloaded = canBeDownloaded;
        this.state = state;
        this.chapters = chapters;
    }

    public Project() {
    }

    @JsonIgnore
    public String getProjectId() {
        return this.projectId;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public long getUnixCreateDate() {
        return this.unixCreateDate;
    }

    @JsonIgnore
    public String getDefaultTitleVoiceId() {
        return this.defaultTitleVoiceId;
    }

    @JsonIgnore
    public String getDefaultParagraphVoiceId() {
        return this.defaultParagraphVoiceId;
    }

    @JsonIgnore
    public String getDefaultModelId() {
        return this.defaultModelId;
    }

    @JsonIgnore
    public long getLastConversionDateUnix() {
        return this.lastConversionDateUnix;
    }

    @JsonIgnore
    public boolean isCanBeDownloaded() {
        return this.canBeDownloaded;
    }

    @JsonIgnore
    public String getState() {
        return this.state;
    }

    @JsonIgnore
    public List<Chapter> getChapters() {
        return this.chapters;
    }

    @JsonIgnore
    public String toString() {
        return "Project{projectId='" + this.projectId + "', name='" + this.name + "', unixCreateDate=" + this.unixCreateDate + ", defaultTitleVoiceId='" + this.defaultTitleVoiceId + "', defaultParagraphVoiceId='" + this.defaultParagraphVoiceId + "', defaultModelId='" + this.defaultModelId + "', lastConversionDateUnix=" + this.lastConversionDateUnix + ", canBeDownloaded=" + this.canBeDownloaded + ", state='" + this.state + "', chapters=" + this.chapters + "}";
    }
}

