/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.voice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.model.ElevenModel;
import net.andrewcpu.elevenlabs.model.voice.Voice;

public class Sample
extends ElevenModel {
    @JsonProperty(value="sample_id")
    private String sampleId;
    @JsonProperty(value="file_name")
    private String fileName;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty(value="size_bytes")
    private long sizeBytes;
    @JsonProperty(value="hash")
    private String hash;
    @JsonIgnore
    public Voice voice;

    public Sample(String sampleId, String fileName, String mimeType, long sizeBytes, String hash) {
        this.sampleId = sampleId;
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.sizeBytes = sizeBytes;
        this.hash = hash;
    }

    public Sample() {
    }

    @JsonIgnore
    public String getSampleId() {
        return this.sampleId;
    }

    @JsonIgnore
    public String getFileName() {
        return this.fileName;
    }

    @JsonIgnore
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonIgnore
    public long getSizeBytes() {
        return this.sizeBytes;
    }

    @JsonIgnore
    public String getHash() {
        return this.hash;
    }

    public File downloadAudio() {
        return ElevenLabs.getSampleAPI().getAudioSample(this.voice.getVoiceId(), this.sampleId);
    }

    public String delete() {
        return ElevenLabs.getSampleAPI().deleteSample(this.voice.getVoiceId(), this.sampleId);
    }

    @JsonIgnore
    public String toString() {
        return "Sample{sampleId='" + this.sampleId + "', fileName='" + this.fileName + "', mimeType='" + this.mimeType + "', sizeBytes=" + this.sizeBytes + ", hash='" + this.hash + "'}";
    }
}

