/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.voice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.enums.GeneratedAudioOutputFormat;
import net.andrewcpu.elevenlabs.enums.StreamLatencyOptimization;
import net.andrewcpu.elevenlabs.model.ElevenModel;
import net.andrewcpu.elevenlabs.model.tuning.FineTuning;
import net.andrewcpu.elevenlabs.model.voice.Sample;
import net.andrewcpu.elevenlabs.model.voice.Sharing;
import net.andrewcpu.elevenlabs.model.voice.VoiceSettings;

public class Voice
extends ElevenModel {
    @JsonProperty(value="voice_id")
    private String voiceId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="samples")
    private List<Sample> samples;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="fine_tuning")
    private FineTuning fineTuning;
    @JsonProperty(value="labels")
    private Map<String, String> labels;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="preview_url")
    private String previewUrl;
    @JsonProperty(value="available_for_tiers")
    private List<String> availableForTiers;
    @JsonProperty(value="settings")
    private VoiceSettings settings;
    @JsonProperty(value="sharing")
    private Sharing sharing;
    @JsonProperty(value="high_quality_base_model_ids")
    private List<String> highQualityBaseModelIds;

    public static List<Voice> getVoices() {
        return ElevenLabs.getVoiceAPI().getVoices();
    }

    public static Voice getVoice(String voiceId) {
        return ElevenLabs.getVoiceAPI().getVoice(voiceId);
    }

    public static Voice getVoice(String voiceId, boolean withSettings) {
        return ElevenLabs.getVoiceAPI().getVoice(voiceId, withSettings);
    }

    @JsonIgnore
    public String getVoiceId() {
        return this.voiceId;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public List<Sample> getSamples() {
        return this.samples.stream().peek(s -> {
            s.voice = this;
        }).collect(Collectors.toList());
    }

    @JsonIgnore
    public String getCategory() {
        return this.category;
    }

    @JsonIgnore
    public FineTuning getFineTuning() {
        return this.fineTuning;
    }

    @JsonIgnore
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getPreviewUrl() {
        return this.previewUrl;
    }

    @JsonIgnore
    public List<String> getAvailableForTiers() {
        return this.availableForTiers;
    }

    @JsonIgnore
    public VoiceSettings getSettings() {
        return this.settings;
    }

    @JsonIgnore
    public Sharing getSharing() {
        return this.sharing;
    }

    public String delete() {
        return ElevenLabs.getVoiceAPI().deleteVoice(this.voiceId);
    }

    public VoiceSettings fetchSettings() {
        this.settings = ElevenLabs.getVoiceAPI().getVoiceSettings(this.voiceId);
        return this.settings;
    }

    public VoiceSettings updateVoiceSettings(VoiceSettings voiceSettings) {
        ElevenLabs.getVoiceAPI().editVoiceSettings(this.voiceId, voiceSettings);
        this.settings = voiceSettings;
        return this.settings;
    }

    public Voice refresh() {
        Voice refreshedData = Voice.getVoice(this.voiceId, true);
        this.name = refreshedData.name;
        this.settings = refreshedData.settings;
        this.voiceId = refreshedData.voiceId;
        this.labels = refreshedData.labels;
        this.description = refreshedData.description;
        this.samples = refreshedData.samples;
        this.fineTuning = refreshedData.fineTuning;
        this.availableForTiers = refreshedData.availableForTiers;
        this.sharing = refreshedData.sharing;
        this.previewUrl = refreshedData.previewUrl;
        this.category = refreshedData.category;
        this.highQualityBaseModelIds = refreshedData.highQualityBaseModelIds;
        return this;
    }

    public File generate(String text, String model) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, model, this.settings);
    }

    public File generate(String text, String model, VoiceSettings settings) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, model, settings);
    }

    public File generate(String text, String model, VoiceSettings settings, GeneratedAudioOutputFormat outputFormat, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, model, outputFormat, streamLatencyOptimization, settings);
    }

    public File generate(String text, String model, VoiceSettings settings, GeneratedAudioOutputFormat outputFormat) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, model, outputFormat, StreamLatencyOptimization.getDefault(), settings);
    }

    public File generate(String text, VoiceSettings settings, GeneratedAudioOutputFormat outputFormat) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, ElevenLabs.getDefaultModel(), outputFormat, StreamLatencyOptimization.getDefault(), settings);
    }

    public File generate(String text, VoiceSettings settings, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, ElevenLabs.getDefaultModel(), GeneratedAudioOutputFormat.getDefault(), streamLatencyOptimization, settings);
    }

    public File generate(String text, VoiceSettings settings, GeneratedAudioOutputFormat outputFormat, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, ElevenLabs.getDefaultModel(), outputFormat, streamLatencyOptimization, settings);
    }

    public File generate(String text, GeneratedAudioOutputFormat outputFormat, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, ElevenLabs.getDefaultModel(), outputFormat, streamLatencyOptimization, this.settings);
    }

    public File generate(String text, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, ElevenLabs.getDefaultModel(), GeneratedAudioOutputFormat.getDefault(), streamLatencyOptimization, this.settings);
    }

    public File generate(String text, VoiceSettings settings) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, ElevenLabs.getDefaultModel(), settings);
    }

    public File generate(String text) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeech(this.voiceId, text, ElevenLabs.getDefaultModel(), this.settings);
    }

    public InputStream generateStream(String text, String model) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, model, this.settings);
    }

    public InputStream generateStream(String text, String model, VoiceSettings settings) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, model, settings);
    }

    public InputStream generateStream(String text, VoiceSettings settings) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, ElevenLabs.getDefaultModel(), settings);
    }

    public InputStream generateStream(String text) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, ElevenLabs.getDefaultModel(), this.settings);
    }

    public InputStream generateStream(String text, String model, GeneratedAudioOutputFormat generatedAudioOutputFormat, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, model, generatedAudioOutputFormat, streamLatencyOptimization, this.settings);
    }

    public InputStream generateStream(String text, String model, GeneratedAudioOutputFormat generatedAudioOutputFormat, StreamLatencyOptimization streamLatencyOptimization, VoiceSettings settings) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, model, generatedAudioOutputFormat, streamLatencyOptimization, settings);
    }

    public InputStream generateStream(String text, VoiceSettings settings, GeneratedAudioOutputFormat generatedAudioOutputFormat, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, ElevenLabs.getDefaultModel(), generatedAudioOutputFormat, streamLatencyOptimization, settings);
    }

    public InputStream generateStream(String text, GeneratedAudioOutputFormat generatedAudioOutputFormat, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, ElevenLabs.getDefaultModel(), generatedAudioOutputFormat, streamLatencyOptimization, this.settings);
    }

    public InputStream generateStream(String text, String model, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, model, GeneratedAudioOutputFormat.getDefault(), streamLatencyOptimization, this.settings);
    }

    public InputStream generateStream(String text, String model, StreamLatencyOptimization streamLatencyOptimization, VoiceSettings settings) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, model, GeneratedAudioOutputFormat.getDefault(), streamLatencyOptimization, settings);
    }

    public InputStream generateStream(String text, VoiceSettings settings, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, ElevenLabs.getDefaultModel(), GeneratedAudioOutputFormat.getDefault(), streamLatencyOptimization, settings);
    }

    public InputStream generateStream(String text, StreamLatencyOptimization streamLatencyOptimization) {
        return ElevenLabs.getTextToSpeechAPI().generateTextToSpeechStreamed(this.voiceId, text, ElevenLabs.getDefaultModel(), GeneratedAudioOutputFormat.getDefault(), streamLatencyOptimization, this.settings);
    }

    public File speechToSpeech(File audioFile, StreamLatencyOptimization latencyOptimization, String modelId, VoiceSettings voiceSettings) {
        return ElevenLabs.getSpeechToSpeechAPI().generateSpeechToSpeech(this.voiceId, voiceSettings, modelId, audioFile, latencyOptimization);
    }

    public File speechToSpeech(File audioFile, StreamLatencyOptimization latencyOptimization, String modelId) {
        return this.speechToSpeech(audioFile, latencyOptimization, modelId, this.settings);
    }

    public File speechToSpeech(File audioFile, String modelId) {
        return this.speechToSpeech(audioFile, StreamLatencyOptimization.getDefault(), modelId, this.settings);
    }

    public InputStream speechToSpeechStream(File audioFile, StreamLatencyOptimization latencyOptimization, String modelId, VoiceSettings voiceSettings) {
        return ElevenLabs.getSpeechToSpeechAPI().generateSpeechToSpeechStream(this.voiceId, voiceSettings, modelId, audioFile, latencyOptimization);
    }

    public InputStream speechToSpeechStream(File audioFile, StreamLatencyOptimization latencyOptimization, String modelId) {
        return this.speechToSpeechStream(audioFile, latencyOptimization, modelId, this.settings);
    }

    public InputStream speechToSpeechStream(File audioFile, String modelId) {
        return this.speechToSpeechStream(audioFile, StreamLatencyOptimization.getDefault(), modelId);
    }

    @JsonIgnore
    public String toString() {
        return "Voice{voiceId='" + this.voiceId + "', name='" + this.name + "', samples=" + this.samples + ", category='" + this.category + "', fineTuning=" + this.fineTuning + ", labels=" + this.labels + ", description='" + this.description + "', previewUrl='" + this.previewUrl + "', availableForTiers=" + this.availableForTiers + ", settings=" + this.settings + ", sharing=" + this.sharing + ", highQualityBaseModelIds=" + this.highQualityBaseModelIds + "}";
    }
}

