/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.voice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.model.ElevenModel;

public class VoiceSettings
extends ElevenModel {
    @JsonProperty(value="stability")
    private double stability;
    @JsonProperty(value="similarity_boost")
    private double similarityBoost;
    @JsonProperty(value="style")
    private double style;
    @JsonProperty(value="use_speaker_boost")
    private boolean useSpeakerBoost;

    public static VoiceSettings getDefaultVoiceSettings() {
        return ElevenLabs.getVoiceAPI().getDefaultVoiceSettings();
    }

    public VoiceSettings(double stability, double similarityBoost, double style, boolean useSpeakerBoost) {
        this.stability = stability;
        this.similarityBoost = similarityBoost;
        this.style = style;
        this.useSpeakerBoost = useSpeakerBoost;
    }

    public VoiceSettings(double stability, double similarityBoost) {
        this.stability = stability;
        this.similarityBoost = similarityBoost;
        this.style = 0.0;
        this.useSpeakerBoost = true;
    }

    public VoiceSettings() {
    }

    @JsonIgnore
    public double getStability() {
        return this.stability;
    }

    @JsonIgnore
    public double getSimilarityBoost() {
        return this.similarityBoost;
    }

    @JsonIgnore
    public double getStyle() {
        return this.style;
    }

    @JsonIgnore
    public boolean isUseSpeakerBoost() {
        return this.useSpeakerBoost;
    }

    @JsonIgnore
    public String toString() {
        return "VoiceSettings{stability=" + this.stability + ", similarityBoost=" + this.similarityBoost + ", style=" + this.style + ", useSpeakerBoost=" + this.useSpeakerBoost + "}";
    }
}

