/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.requests;

import java.util.HashMap;
import java.util.Map;
import net.andrewcpu.elevenlabs.enums.HttpRequestType;
import net.andrewcpu.elevenlabs.util.ElevenNetworkUtil;

public abstract class ElevenLabsRequest<T> {
    private final HttpRequestType type;
    private final String endpoint;
    private final Class<T> responseClass;

    public ElevenLabsRequest(HttpRequestType type, String endpoint, Class<T> clazz) {
        this.type = type;
        this.endpoint = endpoint;
        this.responseClass = clazz;
    }

    public HttpRequestType getType() {
        return this.type;
    }

    public String getEndpoint() {
        Map<String, String> params = this.getQueryParameters();
        if (params.isEmpty()) {
            return this.endpoint;
        }
        return this.endpoint + "?" + ElevenNetworkUtil.buildQueryParameters(this.getQueryParameters());
    }

    public Map<String, String> getQueryParameters() {
        return new HashMap<String, String>();
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    public abstract Object getPayload();
}

