/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.requests.projects;

import java.util.Map;
import net.andrewcpu.elevenlabs.model.request.AddProjectRequest;
import net.andrewcpu.elevenlabs.model.response.ProjectModelResponse;
import net.andrewcpu.elevenlabs.requests.PostMultipartRequest;

public class PostAddProjectRequest
extends PostMultipartRequest<ProjectModelResponse> {
    private final AddProjectRequest request;

    public PostAddProjectRequest(AddProjectRequest request) {
        super("v1/projects/add", ProjectModelResponse.class);
        this.request = request;
    }

    @Override
    public Map<String, Object> getMultipartParts(Map<String, Object> payload) {
        payload.put("name", this.request.getName());
        payload.put("from_url", this.request.getFromUrl());
        payload.put("from_document", this.request.getFromDocument());
        payload.put("default_title_voice_id", this.request.getDefaultTitleVoiceId());
        payload.put("default_paragraph_voice_id", this.request.getDefaultParagraphVoiceId());
        payload.put("default_model_id", this.request.getDefaultModelId());
        payload.put("quality_preset", this.request.getProjectOutputQuality().name().toLowerCase());
        payload.put("title", this.request.getTitle());
        payload.put("author", this.request.getAuthor());
        payload.put("isbn_number", this.request.getIsbnNumber());
        payload.put("acx_volume_normalization", this.request.isAcxVolumeNormalization());
        return payload;
    }
}

