/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.db.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.SocketException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.anotheria.db.config.JDBCConfig;
import net.anotheria.db.config.JDBCConfigFactory;
import net.anotheria.db.service.JDBCConnectionException;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePersistenceServiceJDBCImpl {
    private BasicDataSource dataSource;
    protected Logger log = LoggerFactory.getLogger(BasePersistenceServiceJDBCImpl.class.getClass());
    private GenericReconnectionProxyFactory proxyFactory;
    private AtomicBoolean isBeingReconnected = new AtomicBoolean(false);
    private String configName;

    protected BasePersistenceServiceJDBCImpl() {
        this(null);
    }

    protected BasePersistenceServiceJDBCImpl(String aConfigName) {
        this.configName = aConfigName;
        this.proxyFactory = new GenericReconnectionProxyFactory();
        this.init();
    }

    public void init() {
        BasicDataSource newDataSource = new BasicDataSource();
        JDBCConfig config = this.configName == null ? JDBCConfigFactory.getJDBCConfig() : JDBCConfigFactory.getNamedJDBCConfig(this.configName);
        this.log.info("Using config: " + config);
        newDataSource.setDriverClassName(config.getDriver());
        if (config.getPreconfiguredJdbcUrl() != null && config.getPreconfiguredJdbcUrl().length() > 0) {
            newDataSource.setUrl(config.getPreconfiguredJdbcUrl());
        } else {
            newDataSource.setUrl("jdbc:" + config.getVendor() + "://" + config.getHost() + ":" + config.getPort() + "/" + config.getDb());
        }
        newDataSource.setUsername(config.getUsername());
        newDataSource.setPassword(config.getPassword());
        if (config.getMaxConnections() != Integer.MAX_VALUE) {
            newDataSource.setMaxActive(config.getMaxConnections());
        }
        this.dataSource = newDataSource;
    }

    protected Connection getConnection() throws SQLException {
        if (this.isBeingReconnected.get()) {
            throw new JDBCConnectionException("Database connection problem.");
        }
        try {
            return (Connection)Connection.class.cast(this.proxyFactory.makeProxy(Connection.class, this.dataSource.getConnection()));
        }
        catch (SQLException sqle) {
            this.handleJDBCConnectionException(sqle);
            throw sqle;
        }
    }

    protected void close(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void close(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void release(Connection conn) {
        this.close(conn);
    }

    protected void release(Statement st) {
        this.close(st);
    }

    protected void release(ResultSet rs) {
        this.close(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJDBCConnectionException(Throwable error) throws JDBCConnectionException {
        if (this.isBeingReconnected.get()) {
            throw new JDBCConnectionException("Database connection problem.");
        }
        if (error instanceof SocketException || error instanceof ConnectException) {
            this.isBeingReconnected.set(true);
            try {
                this.init();
            }
            finally {
                this.isBeingReconnected.set(false);
            }
            throw new JDBCConnectionException("Database connection problem.", error);
        }
        if (error.getCause() != null) {
            this.handleJDBCConnectionException(error.getCause());
        }
    }

    private class GenericReconnectionProxyFactory {
        public static final String CREATE_STATEMENT = "createStatement";
        public static final String PREPARE_STATEMENT = "prepareStatement";
        public static final String PREPARE_CALL = "prepareCall";
        public static final String META_DATA = "getMetaData";
        public static final String CLOSE = "close";
        public static final String IS_CLOSED = "isClosed";
        public final Set<String> methodNames = new HashSet<String>();
        public final Set<String> classNames = new HashSet<String>();

        public GenericReconnectionProxyFactory() {
            this.methodNames.add(CREATE_STATEMENT);
            this.methodNames.add(PREPARE_STATEMENT);
            this.methodNames.add(PREPARE_CALL);
            this.methodNames.add(META_DATA);
            this.methodNames.add(CLOSE);
            this.methodNames.add(IS_CLOSED);
            this.classNames.add(Connection.class.getName());
            this.classNames.add(DatabaseMetaData.class.getName());
            this.classNames.add(Statement.class.getName());
            this.classNames.add(PreparedStatement.class.getName());
            this.classNames.add(CallableStatement.class.getName());
            this.classNames.add(ResultSet.class.getName());
        }

        public Object makeProxy(Class<?> intf, final Object obj) {
            if (this.classNames.contains(intf.getName())) {
                return Proxy.newProxyInstance(obj.getClass().getClassLoader(), new Class[]{intf}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (GenericReconnectionProxyFactory.this.classNames.contains(method.getDeclaringClass().getName()) && GenericReconnectionProxyFactory.this.methodNames.contains(method.getName())) {
                            return GenericReconnectionProxyFactory.this.makeProxy(method.getReturnType(), GenericReconnectionProxyFactory.this.invokeMethod(obj, method, args));
                        }
                        return GenericReconnectionProxyFactory.this.invokeMethod(obj, method, args);
                    }
                });
            }
            return obj;
        }

        public Object invokeMethod(Object proxy, Method method, Object[] args) throws Throwable {
            if (BasePersistenceServiceJDBCImpl.this.isBeingReconnected.get()) {
                throw new JDBCConnectionException("Database connection problem.");
            }
            try {
                return method.invoke(proxy, args);
            }
            catch (InvocationTargetException e) {
                BasePersistenceServiceJDBCImpl.this.handleJDBCConnectionException(e);
                throw e.getCause();
            }
        }
    }
}

