/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.db.service;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.db.service.BasePersistenceServiceJDBCImpl;
import net.anotheria.db.util.JDBCUtil;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericPersistenceService
extends BasePersistenceServiceJDBCImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GenericPersistenceService.class.getName());
    public static final String DMD_F_TABLE_NAME = "TABLE_NAME";
    private AtomicLong id = new AtomicLong();

    public GenericPersistenceService() {
        this(null);
    }

    public GenericPersistenceService(String configFile) {
        super(configFile);
    }

    protected void initialize() {
        if (StringUtils.isEmpty((String)this.getTableName())) {
            return;
        }
        this.initializePersistence();
        if (StringUtils.isEmpty((String)this.getPKFieldName())) {
            return;
        }
        this.initializeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePersistence() {
        if (this.isTableExist()) {
            return;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            st = conn.createStatement();
            for (String ddlQuery : this.getDDL()) {
                st.executeUpdate(ddlQuery);
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                JDBCUtil.rollback(conn);
                String message = "initializePersistence() fail.";
                LOGGER.error(message, (Throwable)e);
                new RuntimeException(message, e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(st);
                JDBCUtil.release(conn);
                throw throwable;
            }
            JDBCUtil.release(st);
            JDBCUtil.release(conn);
        }
        JDBCUtil.release(st);
        JDBCUtil.release(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTableExist() {
        ResultSet rs;
        Connection conn;
        block8: {
            boolean bl;
            block7: {
                conn = null;
                rs = null;
                try {
                    conn = this.getConnection();
                    conn.setAutoCommit(true);
                    DatabaseMetaData dmd = conn.getMetaData();
                    rs = dmd.getTables(null, null, null, new String[]{"TABLE"});
                    while (rs.next()) {
                        String currentTable = rs.getString(DMD_F_TABLE_NAME);
                        if (StringUtils.isEmpty((String)currentTable) || !currentTable.equalsIgnoreCase(this.getTableName())) continue;
                        bl = true;
                        JDBCUtil.release(rs);
                        break block7;
                    }
                    JDBCUtil.release(rs);
                    break block8;
                }
                catch (SQLException e) {
                    String message = "isTableExist() fail.";
                    LOGGER.error(message, (Throwable)e);
                    new RuntimeException(message, e);
                    return false;
                }
            }
            JDBCUtil.release(conn);
            return bl;
        }
        JDBCUtil.release(conn);
        return false;
        finally {
            JDBCUtil.release(rs);
            JDBCUtil.release(conn);
        }
    }

    protected abstract List<String> getDDL();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeId() {
        String tableName = this.getTableName();
        String fieldName = this.getPKFieldName();
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(true);
            st = conn.createStatement();
            rs = st.executeQuery("SELECT MAX(" + fieldName + ") FROM " + tableName);
            if (rs.next()) {
                this.id.set(rs.getLong(1));
            }
            LOGGER.debug("initId(" + tableName + ", " + fieldName + ") success. Id: " + this.id.get());
        }
        catch (SQLException e) {
            try {
                String message = "initId(" + tableName + ", " + fieldName + ") fail.";
                LOGGER.error(message, (Throwable)e);
                new RuntimeException(message, e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(rs);
                JDBCUtil.release(st);
                JDBCUtil.release(conn);
                throw throwable;
            }
            JDBCUtil.release(rs);
            JDBCUtil.release(st);
            JDBCUtil.release(conn);
        }
        JDBCUtil.release(rs);
        JDBCUtil.release(st);
        JDBCUtil.release(conn);
    }

    protected abstract String getTableName();

    protected abstract String getPKFieldName();

    protected long getNextId() {
        return this.id.incrementAndGet();
    }
}

